% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R, R/spectral_function.R
\name{layout_igraph_eigen}
\alias{layout_igraph_eigen}
\alias{spectral_layout}
\alias{layout_with_eigen}
\title{spectral graph layouts}
\usage{
layout_igraph_eigen(g, type = "laplacian", ev = "smallest", circular)

layout_with_eigen(g, type = "laplacian", ev = "smallest")
}
\arguments{
\item{g}{igraph object}

\item{type}{matrix to be used for spectral decomposition. either 'adjacency' or 'laplacian'}

\item{ev}{eigenvectors to be used. Either 'smallest' or 'largest'.}

\item{circular}{not used}
}
\value{
coordinates to be used layouting a graph
}
\description{
Using a set of eigenvectors of matrices associated with a graph as coordinates
}
\details{
the layout_igraph_* function should not be used directly. It is only used as an argument for 'ggraph'.
}
\examples{
library(igraph)
library(ggraph)

g <- sample_gnp(50,0.2)

ggraph(g,layout="eigen",type="adjacency",ev="largest")+
  geom_edge_link(n=2,edge_colour="grey66")+
  geom_node_point(shape=21,fill="grey25",size=5)+
  theme_graph()

ggraph(g,layout="eigen",type="adjacency",ev="smallest")+
  geom_edge_link(n=2,edge_colour="grey66")+
  geom_node_point(shape=21,fill="grey25",size=5)+
  theme_graph()


ggraph(g,layout="eigen",type="laplacian",ev="largest")+
  geom_edge_link(n=2,edge_colour="grey66")+
  geom_node_point(shape=21,fill="grey25",size=5)+
  theme_graph()

ggraph(g,layout="eigen",type="laplacian",ev="smallest")+
  geom_edge_link(n=2,edge_colour="grey66")+
  geom_node_point(shape=21,fill="grey25",size=5)+
  theme_graph()
}
