% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{Gamma2graph}
\alias{Gamma2graph}
\alias{Theta2graph}
\title{Transformation of matrix to graph object}
\usage{
Gamma2graph(Gamma, tol = get_large_tol())

Theta2graph(Theta, tol = get_large_tol())
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{tol}{Numeric scalar, entries in the precision matrix with absolute value
smaller than this are considered to be zero.}

\item{Theta}{Numeric \dxd precision matrix.}
}
\value{
Graph object from \code{igraph} package. An undirected graph.
}
\description{
Transforms a \eGamma or \eTheta matrix to an \code{\link[igraph:make_graph]{igraph::graph}} object for
the corresponding Huesler--Reiss extremal graphical model.
}
\examples{
Gamma <- cbind(
  c(0, 1.5, 1.5, 2),
  c(1.5, 0, 2, 1.5),
  c(1.5, 2, 0, 1.5),
  c(2, 1.5, 1.5, 0)
)

Gamma2graph(Gamma)

}
\seealso{
\code{\link[=get_large_tol]{get_large_tol()}}

Other MatrixTransformations: 
\code{\link{Gamma2Sigma}()},
\code{\link{Gamma2Theta}()},
\code{\link{Sigma2Gamma}()},
\code{\link{Theta2Gamma}()}
}
\concept{MatrixTransformations}
