% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{PairwiseDESeq2}
\alias{PairwiseDESeq2}
\title{Perform Wald tests for differential expression}
\usage{
PairwiseDESeq2(
  data,
  name.prefix = mode,
  contrasts,
  separate = FALSE,
  mode = "total",
  slot = "count",
  normalization = NULL,
  logFC = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{the grandR object}

\item{name.prefix}{the prefix for the new analysis name; a dot and the column names of the contrast matrix are appended; can be NULL (then only the contrast matrix names are used)}

\item{contrasts}{contrast matrix that defines all pairwise comparisons, generated using \link{GetContrasts}}

\item{separate}{model overdispersion separately for all pairwise comparison (TRUE), or fit a single model per gene, and extract contrasts (FALSE)}

\item{mode}{compute LFCs for "total", "new", or "old" RNA}

\item{slot}{which slot to use (should be a count slot, not normalized values)}

\item{normalization}{normalize on "total", "new", or "old" (see details)}

\item{logFC}{compute and add the log2 fold change as well}

\item{verbose}{print status messages?}
}
\value{
a new grandR object including a new analysis table. The columns of the new analysis table are
\itemize{
 \item{"M"}{the base mean}
 \item{"S"}{the log2FoldChange divided by lfcSE}
 \item{"P"}{the Wald test P value}
 \item{"Q"}{same as P but Benjamini-Hochberg multiple testing corrected}
 \item{"LFC"}{the log2 fold change (only with the logFC parameter set to TRUE)}
}
}
\description{
Apply DESeq2 for comparisons defined in a contrast matrix, requires the DESeq2 package.
}
\details{
DESeq2 by default performs size factor normalization. When computing differential expression of new RNA,
it might be sensible to normalize w.r.t. to total RNA, i.e. use the size factors computed from total RNA instead of computed from new RNA.
This can be accomplished by setting mode to "new", and normalization to "total"!

Normalization can also be a mode.slot! Importantly, do not specify a slot containing normalized values, but specify a slot of unnormalized values
(which are used to compute the size factors for normalization!)
}
\examples{
\donttest{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c(Design$Condition,Design$dur.4sU,Design$Replicate))
sars <- subset(sars,Coldata(sars,Design$dur.4sU)==2)
sars<-PairwiseDESeq2(sars,mode="total",
                              contrasts=GetContrasts(sars,contrast=c("Condition","Mock")))
sars<-PairwiseDESeq2(sars,mode="new",normalization="total",
                              contrasts=GetContrasts(sars,contrast=c("Condition","Mock")))
head(GetAnalysisTable(sars,column="Q"))
}

}
\seealso{
\link{LFC},\link{GetContrasts}
}
\concept{diffexp}
