% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_anova.R
\name{simple_anova}
\alias{simple_anova}
\title{ANOVA table from a linear model fit to data.}
\usage{
simple_anova(data, Y_value, Fixed_Factor, ...)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{Y_value}{name of column containing quantitative (dependent) variable, provided within "quotes".}

\item{Fixed_Factor}{name(s) of categorical fixed factors (independent variables) provided as a vector if more than one or within "quotes".}

\item{...}{any additional argument to pass on to \code{\link{lm}} if required.}
}
\value{
ANOVA table of class "anova" and "data.frame".
}
\description{
Update in v0.2.1: This function uses \code{\link{lm}} to fit a linear model to data, passes it on to \code{\link[car]{Anova}}, and outputs the ANOVA table with type II sum of squares with F statistics and \emph{P} values.
(Previous versions produced type I sum of squares using \code{\link{anova}} call.)
}
\details{
It requires a data table, one quantitative dependent variable and one or more independent variables. If your experiment design has random factors, use the related function \code{\link{mixed_anova}}.

This function is related to \code{link{simple_model}}.
}
\examples{
#Basic usage 
simple_anova(data = data_doubling_time, 
Y_value = "Doubling_time", 
Fixed_Factor = "Student")

}
