% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_point_sd_sc.R
\name{plot_point_sd_sc}
\alias{plot_point_sd_sc}
\title{Plot a point as mean with SD error bars using two variables.}
\usage{
plot_point_sd_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  s_alpha = 1,
  symsize = 3.5,
  symthick = 1,
  ewid = 0.2,
  TextXAngle = 0,
  fontsize = 20
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column with a categorical X variable.}

\item{ycol}{name of the column with quantitative Y variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{symsize}{size of point symbols, default set to 3.5.}

\item{symthick}{thickness of symbol border, default set to 1}

\item{ewid}{width of error bars, default set to 0.2.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_point_sd}, but this one maps a single or same colour, therefore \verb{_sc}. The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\details{
You are instead encouraged to show all data using the following functions: \code{\link{plot_scatterbar_sd}}, \code{\link{plot_scatterbox}}, \code{\link{plot_dotbox}}, \code{\link{plot_dotbar_sd}}, \code{\link{plot_scatterviolin}} or \code{\link{plot_dotviolin}}.
}
\examples{
#Basic usage
plot_point_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time)
plot_point_sd_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
colour = "ok_grey")

}
