% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateRandomSequences}
\alias{generateRandomSequences}
\title{Split randomly any R object for which method length() has been defined into a train set and a test set.}
\usage{
generateRandomSequences(n = 2, meanLen = 10, sdLen = 0, seed = NULL,
  ncores = NULL, prob = rep(0.25, 4))
}
\arguments{
\item{n}{- int, number of sequences to generate.}

\item{meanLen}{- float, mean of the length distribution (gaussian) of the generated sequences.}

\item{sdLen}{- float, sd of the length distribution (gaussian) of the generated sequences.}

\item{seed}{- int, when the same seed and parameters are used, exact same sequences are generated.}

\item{ncores}{- int, number of cores to use.}

\item{prob}{- vector of length 4 with the probability for the 4 nucleotides (A, C, G, T).}
}
\description{
\code{generateRandomSequences} returns a list with indices for train and test sets.
}
\examples{
generateRandomSequences(n = 2, meanLen = 20, sdLen = 2)
generateRandomSequences(n = 4, meanLen = 5, sdLen = 0)
}
