% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charts.R
\name{google_charts}
\alias{google_charts}
\title{Google Charts}
\description{
Google Charts can be displayed inside an \code{info_window}
}
\section{\code{info_window}}{


When using a chart in an \code{info_window} you need to use a \code{list} with at least
two elements named \code{data} and \code{type}. You can also use a third element called \code{options}
for controlling the appearance of the chart.

You must also supply the \code{id} argument to the layer your are adding (e.g. \code{add_markers()}),
and the \strong{\code{data}} must have a column with the same name as the \code{id} (and therefore
the same name as the \code{id} column in the original \code{data} supplied to the \code{add_} function).

See the specific chart sections for details on how to structure the \code{data}.
}

\section{chart types}{


the \code{type} element can be one of
\itemize{
\item \code{area}
\item \code{bar}
\item \code{bubble}
\item \code{candlestick}
\item \code{column}
\item \code{combo}
\item \code{histogram}
\item \code{line}
\item \code{pie}
\item \code{scatter}
}
}

\section{Area}{


\strong{data}

An area chart requires a \code{data.frame} of at least three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third or more columns: the data used in the chart
}

\strong{type} - \code{area}

\strong{options}
see the area charts documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/areachart}

Each row of data represents a data point at the same x-axis location
}

\section{Bar}{


\strong{data}

A bar chart requires a \code{data.frame} of at least three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third or more columns: the data used in the chart
}

\strong{type} - \code{bar}

\strong{options}

See the bar chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/barchart}
}

\section{Bubble}{


\strong{data}

A bubble chart requires a \code{data.frame} of at least four, and at most six columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third column: x-axis value
\item Fourth column: y-axis value
\item Fith column: visualised as colour
\item Sixth column: visualised as size
}

\strong{type} - \code{bubble}

\strong{options}

See the bubble chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/bubblechart}
}

\section{Candlestick}{


\strong{data}

A candlestick chart requires a \code{data.frame} of at least six columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third column: Number specifying the 'low' number for the data
\item Fourth column: Number specifying the opening/initial value of the data.
This is one vertical border of the candle. If less than the column 4 value,
the candle will be filled; otherwise it will be hollow.
\item Fith column: Number specifying the closing/final value of the data.
This is the second vertical border of the candle. If less than the column 3 value,
the candle will be hollow; otherwise it will be filled.
\item Sixth column: Number specifying the high/maximum value of this marker.
This is the top of the candle's center line.
}

\strong{type} - \code{candlestick}

\strong{options}

See the candlestick chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/candlestickchart}
}

\section{Column}{


\strong{data}

A column chart requires a \code{data.frame} of at least three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third or more columns: the data used in the chart
}

\strong{type} - \code{column}

\strong{options}

See the column chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/columnchart}
}

\section{Combo}{


A combo chart lets you render each series as a different marker type from the following list:
line, area, bars, candlesticks, and stepped area.

\strong{data}

A combo chart requires a \code{data.frame} of at least three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third or more columns: the data used in the chart
}

\strong{type} - \code{combo}

\strong{options}

See the column chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/combochart}
}

\section{Histogram}{


\strong{data}

A histogram chart requires a \code{data.frame} of at least three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third or more columns: the data used in the chart
}

\strong{type} - \code{histogram}

\strong{options}

See the histogram chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/histogram}
}

\section{Line}{


\strong{data}

A line chart requires a \code{data.frame} of at least three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third or more columns: the data used in the chart
}

\strong{type} - \code{line}

\strong{options}

See the line chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/linechart}
}

\section{Pie}{


\strong{data}

A pie chart requires a \code{data.frame} of three columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third column: the data used in the chart
}

\strong{type} - \code{pie}

\strong{options}

See the pie chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/piechart}
}

\section{Scatter}{


\strong{data}

A scatter chart requires a \code{data.frame} of at least four columns:
\enumerate{
\item First column: a column of id values, where the column has the same name as the
id column in the \code{data} argument, and therefore the same name as the value supplied
to the \code{id} argument.
\item Second column: variable names used for labelling the data
\item Third column: the data plotted on x-axis
\item Fourth or more columns: the data plotted on y-axis
}

\strong{type} - \code{scatter}

\strong{options}

See the scatter chart documentation for various other examples
\url{https://developers.google.com/chart/interactive/docs/gallery/scatterchart}
}

\examples{
\dontrun{

set_key("your_api_key")

## AREA
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 2),
    year = rep( c("year1", "year2")),
    arrivals = sample(1:100, size = nrow(tram_stops) * 2, replace = T),
    departures = sample(1:100, size = nrow(tram_stops) * 2, replace = T))

chartList <- list(data = markerCharts,
   type = 'area',
   options = list(width = 400, chartArea = list(width = "50\%")))

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")

tram_route$id <- c(rep(1, 30), rep(2, 25))

lineCharts <- data.frame(id = rep(c(1,2), each = 2),
    year = rep( c("year1", "year2") ),
    arrivals = sample(1:100, size = 4),
    departures = sample(1:100, size = 4))

chartList <- list(data = lineCharts,
   type = 'area')

google_map() \%>\%
  add_polylines(data = tram_route, id = 'id',
    stroke_colour = "id", stroke_weight = 10,
    lat = "shape_pt_lat", lon = "shape_pt_lon",
    info_window = chartList
    )

}

\dontrun{

## BAR
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 2),
    year = rep( c("year1", "year2")),
    arrivals = sample(1:100, size = nrow(tram_stops) * 2, replace = T),
    departures = sample(1:100, size = nrow(tram_stops) * 2, replace = T))

chartList <- list(data = markerCharts,
   type = 'bar')

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")


lineChart <- data.frame(id = 33,
    year = c("year1","year2"),
    val1 = c(1,2),
    val2 = c(2,1))

chartList <- list(data = lineChart, type = 'bar')

google_map() \%>\%
  add_polylines(data = melbourne[melbourne$polygonId == 33, ],
  polyline = "polyline",
  info_window = chartList)

}


\dontrun{

## BUBBLE
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 4),
    ID = sample(letters, size = nrow(tram_stops) * 4, replace = T),
    time = sample(1:1440, size = nrow(tram_stops) * 4, replace = T),
    passengers = sample(1:100, size = nrow(tram_stops) * 4, replace = T),
    year = c("year1", "year2", "year3", "year4"),
    group = sample(50:100, size = nrow(tram_stops) * 4, replace = T))

chartList <- list(data = markerCharts,
   type = 'bubble')

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")

}

\dontrun{

## CANDLESTICK
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 5),
    day = rep(c("Mon", "Tues", "Weds", "Thurs", "Fri"), times = nrow(tram_stops) ),
    val1 = rep(c(20, 31, 50, 77, 68), times = nrow(tram_stops) ),
    val2 = rep(c(28, 38, 55, 77, 66), times = nrow(tram_stops) ),
    val3 = rep(c(38, 55, 77, 66, 22), times = nrow(tram_stops) ),
    val4 = rep(c(45, 66, 80, 50, 15), times = nrow(tram_stops) ) )

chartList <- list(data = markerCharts,
   type = 'candlestick',
   options = list(legend = 'none',
     bar = list(groupWidth = "100\%"),
     candlestick = list(
       fallingColor = list( strokeWidth = 0, fill = "#a52714"),
       risingColor = list( strokeWidth = 0, fill = "#0f9d58")
       )
     ))

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")

}


\dontrun{

## COLUMN
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 2),
    year = rep( c("year1", "year2")),
    arrivals = sample(1:100, size = nrow(tram_stops) * 2, replace = T),
    departures = sample(1:100, size = nrow(tram_stops) * 2, replace = T))

chartList <- list(data = markerCharts,
   type = 'column')

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")

polyChart <- data.frame(id = 33,
    year = c("year1","year2"),
    val1 = c(1,2),
    val2 = c(2,1))

chartList <- list(data = polyChart, type = 'column')

google_map() \%>\%
  add_polygons(data = melbourne[melbourne$polygonId == 33, ],
  polyline = "polyline",
  info_window = chartList)

tram_route$id <- 1

polyChart <- data.frame(id = 1,
    year = c("year1","year2"),
    val1 = c(1,2),
    val2 = c(2,1))

chartList <- list(data = polyChart, type = 'column')

google_map() \%>\%
  add_polygons(data = tram_route,
    lon = "shape_pt_lon", lat = "shape_pt_lat",
    info_window = chartList)


}

\dontrun{


## COMBO
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 2),
    year = rep( c("year1", "year2")),
    arrivals = sample(1:100, size = nrow(tram_stops) * 2, replace = T),
    departures = sample(1:100, size = nrow(tram_stops) * 2, replace = T))

markerCharts$val <- sample(1:100, size = nrow(markerCharts), replace = T)

chartList <- list(data = markerCharts,
   type = 'combo',
   options = list(
     "title" = "Passengers at stops",
     "vAxis" = list( title = "passengers" ),
     "hAxis" = list( title = "load" ),
     "seriesType" = "bars",
     "series" = list( "2" = list( "type" = "line" )))) ## 0-indexed

google_map() \%>\%
  add_circles(data = tram_stops, info_window = chartList, id = "stop_id")

}


\dontrun{

## HISTOGRAM
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 20),
    day = as.character(1:20))

markerCharts$wait <- rnorm(nrow(markerCharts), 0, 1)

chartList <- list(data = markerCharts,
   type = 'histogram')

google_map() \%>\%
  add_circles(data = tram_stops, info_window = chartList, id = "stop_id")

}


\dontrun{

## Line
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 20),
    day = as.character(1:20),
    value = sample(1:100, size = nrow(tram_stops) * 20, replace = T))

chartList <- list(data = markerCharts,
   type = 'line')

google_map() \%>\%
  add_circles(data = tram_stops, info_window = chartList, id = "stop_id")

}


\dontrun{

## PIE
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 3))
markerCharts$variable <- c("yes", "no", "maybe")
markerCharts$value <- sample(1:10, size = nrow(markerCharts), replace = T)

chartList <- list(data = markerCharts,
   type = 'pie',
   options = list(title = "my pie",
     is3D = TRUE,
     height = 240,
     width = 240,
     colors = c('#440154', '#21908C', '#FDE725')))

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")

## use pieHole option to make a donut chart

chartList <- list(data = markerCharts,
   type = 'pie',
   options = list(title = "my pie",
     pieHole = 0.4,
     height = 240,
     width = 240,
     colors = c('#440154', '#21908C', '#FDE725')))

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")

}


\dontrun{

## SCATTER
markerCharts <- data.frame(stop_id = rep(tram_stops$stop_id, each = 5))
markerCharts$arrival <- sample(1:10, size = nrow(markerCharts), replace = T)
markerCharts$departure <- sample(1:10, size = nrow(markerCharts), replace = T)

chartList <- list(data = markerCharts,
   type = 'scatter')

google_map() \%>\%
  add_markers(data = tram_stops, info_window = chartList, id = "stop_id")
}


}
