% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_polygon.R
\name{add_polygons}
\alias{add_polygons}
\title{Add polygon}
\usage{
add_polygons(map, data = get_map_data(map), polyline = NULL, lat = NULL,
  lon = NULL, id = NULL, pathId = NULL, stroke_colour = NULL,
  stroke_weight = NULL, stroke_opacity = NULL, fill_colour = NULL,
  fill_opacity = NULL, info_window = NULL, mouse_over = NULL,
  mouse_over_group = NULL, draggable = NULL, editable = NULL,
  update_map_view = TRUE, layer_id = NULL, z_index = NULL, digits = 4,
  palette = NULL, legend = F, legend_options = NULL, load_interval = 0,
  focus_layer = FALSE)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least a \code{polyline} column,
or a \code{lat} and a \code{lon} column. If Null, the data passed into
\code{google_map()} will be used.}

\item{polyline}{string specifying the column of \code{data} containing
the encoded polyline}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. If left NULL, a best-guess will be made}

\item{id}{string specifying the column containing an identifier for a shape}

\item{pathId}{string specifying the column containing an identifer for each
path that forms the complete polygon. Not required when using \code{polyline},
as each polyline is itself a path.}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each shape, or a number indicating the width of pixels
in the line to be applied to all the shapes}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each shape, or a value between 0 and 1 that will be
applied to all the shapes}

\item{fill_colour}{either a string specifying the column of \code{data} containing
the fill colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{fill_opacity}{either a string specifying the column of \code{data} containing
the fill opacity of each shape, or a value between 0 and 1 that will be applied
to all the shapes}

\item{info_window}{string specifying the column of data to display in an info
window when a shape is clicked.}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the shape}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of shapes to highlight on mouseover}

\item{draggable}{string specifying the column of \code{data} defining if
the polygon is 'draggable'. The column of data should be logical (either TRUE or FALSE)}

\item{editable}{string specifying the column of \code{data} defining if the polygon
is 'editable' (either TRUE or FALSE)}

\item{update_map_view}{logical specifying if the map should re-centre according to
the shapes}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers for when using any \code{update_} function, and
for separating legends.}

\item{z_index}{single value specifying where the circles appear in the layering
of the map objects. Layers with a higher \code{z_index} appear on top of those with
a lower \code{z_index}. See details.}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{palette}{a function, or list of functions, that generates hex colours
given a single number as an input. See details.}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{load_interval}{time in miliseconds to wait between plotting each shape}

\item{focus_layer}{logical indicating if the map should re-centre according to this layer}
}
\description{
Add a polygon to a google map.
}
\details{
\code{z_index} values define the order in which objects appear on the map.
Those with a higher value appear on top of those with a lower value. The default
order of objects is (1 being underneath all other objects)

\itemize{
  \item{1. Polygon}
  \item{2. Rectangle}
  \item{3. Polyline}
  \item{4. Circle}
}

Markers are always the top layer
}
\note{
A polygon represents an area enclosed by a closed path. Polygon objects
are similar to polylines in that they consist of a series of coordinates in an ordered sequence.
Polygon objects can describe complex shapes, including

\itemize{
  \item{Multiple non-contiguous areas defined by a single polygon}
  \item{Areas with holes in them}
  \item{Intersections of one or more areas}
}

To define a complex shape, you use a polygon with multiple paths.

To create a hole in a polygon, you need to create two paths, one inside the other.
To create the hole, the coordinates of the inner path must be wound in the opposite
order to those defining the outer path. For example, if the coordinates of
the outer path are in clockwise order, then the inner path must be anti-clockwise.

You can represent a polygon in one of three ways
\itemize{
  \item{as a series of coordinates defining a path (or paths) with both an
  \code{id} and \code{pathId} argument that make up the polygon}
  \item{as an encoded polyline using an \code{id} column to specify multiple
  polylines for a polygon}
  \item{as a list column in a data.frame, where each row of the data.frame
  contains the polylines that comprise the polygon}

}

See Examples
}
\section{palette}{


The \code{palette} is used to specify the colours that will map to variables.
You can specify a single function to map to all variables, or a named list
that specifies a separate function to map to each variable. The elements must
be named either \code{fill_colour} or \code{stroke_colour}, and their values
are the colour generating functions. The default is \code{viridisLite::viridis}

The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{position - one of \code{c("TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "RIGHT_TOP",
  "RIGHT_CENTER", "RIGHT_BOTTOM", "BOTTOM_RIGHT", "BOTTOM_CENTER", "BOTTOM_LEFT",
  "LEFT_BOTTOM", "LEFT_CENTER", "LEFT_TOP")}}
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
}
if \code{legend_options} are NULL, the default values will apply

If you are displaying two legends, one for \code{stroke_colour} and one
for \code{fill_colour}, you can specify different options for the different
colour attributes. See examples for \link{add_circles}.
}

\examples{
\dontrun{

map_key <- 'your_api_key'

## polygon with a hole - Bermuda triangle
## using one row per polygon, and a list-column of encoded polylines
pl_outer <- encode_pl(lat = c(25.774, 18.466,32.321),
      lon = c(-80.190, -66.118, -64.757))

pl_inner <- encode_pl(lat = c(28.745, 29.570, 27.339),
       lon = c(-70.579, -67.514, -66.668))

df <- data.frame(id = c(1, 1),
       polyline = c(pl_outer, pl_inner),
       stringsAsFactors = FALSE)

df <- aggregate(polyline ~ id, data = df, list)

google_map(key = map_key, height = 800) \%>\%
    add_polygons(data = df, polyline = "polyline")

## the same polygon, but using an 'id' to specify the polygon
df <- data.frame(id = c(1,1),
       polyline = c(pl_outer, pl_inner),
       stringsAsFactors = FALSE)

google_map(key = map_key, height = 800) \%>\%
    add_polygons(data = df, polyline = "polyline", id = "id")

## the same polygon, specified using coordinates, and with a second independent
## polygon
df <- data.frame(myId = c(1,1,1,1,1,1,2,2,2),
      lineId = c(1,1,1,2,2,2,1,1,1),
      lat = c(26.774, 18.466, 32.321, 28.745, 29.570, 27.339, 22, 23, 22),
      lon = c(-80.190, -66.118, -64.757, -70.579, -67.514, -66.668, -50, -49, -51),
      colour = c(rep("#00FF0F", 6), rep("#FF00FF", 3)),
      stringsAsFactors = FALSE)

google_map(key = map_key) \%>\%
  add_polygons(data = df, lat = 'lat', lon = 'lon', id = 'myId', pathId = 'lineId',
               fill_colour = 'colour')



}

}
\seealso{
\link{encode_pl}
}
