% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_id.R
\name{sheets_id}
\alias{sheets_id}
\title{\code{sheets_id} object}
\description{
A \code{sheets_id} is a spreadsheet identifier, i.e. a string. This
is what the Sheets and Drive APIs refer to as \code{spreadsheetId} and \code{fileId},
respectively. When you print a \code{sheets_id}, we attempt to reveal its
current metadata (via \code{gs4_get()}). This can fail for a variety of
reasons (e.g. if you're offline), but the \code{sheets_id} is always revealed
and is returned, invisibly.

Any object of class \code{sheets_id} will also have the
\code{\link[googledrive:as_id]{drive_id}} class, which is used by \link{googledrive} for
the same purpose. This means you can pipe a \code{sheets_id} object straight
into \link{googledrive} functions for all your Google Drive needs that have
nothing to do with the file being a spreadsheet. Examples: examine or
change file name, path, or permissions, copy the file, or visit it in a web
browser.
}
\examples{
if (gs4_has_token()) {
  gs4_example("mini-gap")
}
}
\seealso{
\code{\link[=as_sheets_id]{as_sheets_id()}}
}
