% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_properties.R
\name{sheet_properties}
\alias{sheet_properties}
\alias{sheet_names}
\title{Get data about (work)sheets}
\usage{
sheet_properties(ss)

sheet_names(ss)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, an instance of \code{googlesheets4_spreadsheet}
(returned by \code{\link[=gs4_get]{gs4_get()}}), or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}
}
\value{
\itemize{
\item \code{sheet_properties()}: A tibble with one row per (work)sheet.
\item \code{sheet_names()}: A character vector of (work)sheet names.
}
}
\description{
Reveals full metadata or just the names for the (work)sheets inside a
(spread)Sheet.
}
\examples{
if (gs4_has_token()) {
  ss <- gs4_example("gapminder")
  sheet_properties(ss)
  sheet_names(ss)
}
}
\seealso{
Other worksheet functions: 
\code{\link{sheet_add}()},
\code{\link{sheet_append}()},
\code{\link{sheet_copy}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_relocate}()},
\code{\link{sheet_rename}()},
\code{\link{sheet_resize}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
