% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gd_permissions.R
\name{gs_perm_edit}
\alias{gs_perm_edit}
\title{Edit an existing permission}
\usage{
gs_perm_edit(ss, email = NULL, perm_id = NULL, role = "reader",
  commenter = FALSE, verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{email}{The email address or domain name for the entity.}

\item{perm_id}{The ID for the permission.}

\item{role}{The primary role for this user. Allowed values are "owner",
"reader", and "writer".}

\item{commenter}{logical; allow the user to comment? This is only effective
if role = "reader".}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Assign a new role to an existing user permission. This function is useful
when you want to change roles for an entity, e.g., from "writer" to "reader"
or vice versa.
}
\examples{
\dontrun{
foo <- gs_new("foo")
gs_perm_ls(foo)
# Add anyone as a reader:
gs_perm_add(foo, type = "anyone", role = "reader")
gs_perm_ls(foo)
# Change anyone to a writer:
gs_perm_edit(foo, perm_id = "anyoneWithLink", role = "writer")
gs_perm_ls(foo)
gs_delete(foo)
}

}
\keyword{internal}
