% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{gce_list_registry}
\alias{gce_list_registry}
\title{List the docker images you have on Google Container Registry}
\usage{
gce_list_registry(instance, container_url = "gcr.io",
  project = gce_get_global_project())
}
\arguments{
\item{instance}{The VM to run within}

\item{container_url}{The URL of where the container was saved}

\item{project}{Project ID for this request, default as set by \link{gce_get_global_project}}
}
\description{
List the docker images you have on Google Container Registry
}
\details{
Currently needs to run on a Google VM, not locally
}
\examples{

\dontrun{

  vm <- gce_vm("my_instance")
  gce_list_registry(vm)

}

}
\seealso{
Other container registry functions: \code{\link{gce_pull_registry}},
  \code{\link{gce_push_registry}},
  \code{\link{gce_tag_container}}
}
