% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gce.R
\name{gar_gce_auth}
\alias{gar_gce_auth}
\title{Authenticate on Google Compute Engine}
\usage{
gar_gce_auth(
  service_account = "default",
  scopes = "https://www.googleapis.com/auth/cloud-platform"
)
}
\arguments{
\item{service_account}{Specify a different service account from the \code{default}}

\item{scopes}{Scopes for the authentication}
}
\value{
A token
}
\description{
This takes the metadata auth token in a Google Compute Engine instance as authentication source
}
\details{
\code{service_account} is \code{default} or the service account email 
e.g. \code{"service-account-key-json@projectname.iam.gserviceaccount.com"}

Google Compute Engine instances come with their own authentication tokens.  

It has no refresh token so you need to call for a fresh token after approx. one hour. 
The metadata token will refresh itself when it has about 60 seconds left.

You can only use for scopes specified when creating the instance.

If you want to use them make sure their service account email is added to accounts you want to get data from.

Use \code{options(gargle.gce.use_ip = TRUE)} to activate this upon kubernetes for instance using federated identity
}
\seealso{
\link{gar_gce_auth_email}

Other authentication functions: 
\code{\link{gar_attach_auto_auth}()},
\code{\link{gar_auth_service}()},
\code{\link{gar_auth}()},
\code{\link{gar_auto_auth}()},
\code{\link{get_google_token}()},
\code{\link{token_exists}()}
}
\concept{authentication functions}
