% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_dims_mets.R
\name{ga_custom_vars_patch}
\alias{ga_custom_vars_patch}
\title{Modify a custom dimension}
\usage{
ga_custom_vars_patch(
  id,
  accountId,
  webPropertyId,
  name = NULL,
  active = NULL,
  scope = NULL,
  ignoreCustomDataSourceLinks = FALSE
)
}
\arguments{
\item{id}{The id of the custom dimension}

\item{accountId}{AccountId of the custom dimension}

\item{webPropertyId}{WebPropertyId of the custom dimension}

\item{name}{Name of custom dimension}

\item{active}{\code{TRUE} or \code{FALSE} if custom dimension is active or not}

\item{scope}{Scope of custom dimension - one of \verb{"HIT","SESSION","USER","PRODUCT"}}

\item{ignoreCustomDataSourceLinks}{Force the update and ignore any warnings related to the custom dimension being linked to a custom data source / data set.}
}
\description{
Modify existing custom dimensions
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()

# create custom var
ga_custom_vars_create("my_custom_dim",
                      index = 7,
                      accountId = 54019251,
                      webPropertyId = "UA-54019251-4",
                      scope = "HIT",
                      active = FALSE)

# view custom dimension in list
ga_custom_vars_list(54019251, webPropertyId = "UA-54019251-4", type = "customDimensions")

# change a custom dimension
ga_custom_vars_patch("ga:dimension7",
                     accountId = 54019251,
                     webPropertyId = "UA-54019251-4",
                     name = "my_custom_dim2",
                     active = TRUE)
                     
# view custom dimensions again to see change
ga_custom_vars_list(54019251, webPropertyId = "UA-54019251-4", type = "customDimensions")

}
}
\seealso{
\href{https://support.google.com/analytics/answer/2709828}{Custom dimensions support article}

Other custom variable functions: 
\code{\link{ga_custom_vars_create}()},
\code{\link{ga_custom_vars_list}()},
\code{\link{ga_custom_vars}()}
}
\concept{custom variable functions}
