% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivots.R
\name{pivot_ga4}
\alias{pivot_ga4}
\title{Make a pivot object}
\usage{
pivot_ga4(
  pivot_dim,
  metrics,
  dim_filter_clause = NULL,
  startGroup = 0,
  maxGroupCount = 5
)
}
\arguments{
\item{pivot_dim}{A character vector of dimensions}

\item{metrics}{Metrics to aggregate and return.}

\item{dim_filter_clause}{Only data included in filter included.}

\item{startGroup}{which groups of k columns are included in response (0 indexed).}

\item{maxGroupCount}{Maximum number of groups to return.}
}
\value{
pivot object of class \code{pivot_ga4} for use in \code{\link{filter_clause_ga4}}
}
\description{
Make a pivot object
}
\details{
If maxGroupCount is set to -1 returns all groups.
}
\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, 
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']

## filter pivot results to 
pivot_dim_filter1 <- dim_filter("medium",
                                "REGEXP",
                                "organic|social|email|cpc")
                                
                                
pivot_dim_clause <- filter_clause_ga4(list(pivot_dim_filter1))

pivme <- pivot_ga4("medium",
                   metrics = c("sessions"), 
                   maxGroupCount = 4, 
                  dim_filter_clause = pivot_dim_clause)
                  
                  
pivtest <- google_analytics(ga_id, 
                            c("2016-01-30","2016-10-01"), 
                            dimensions=c('source'), 
                            metrics = c('sessions'), 
                            pivots = list(pivme))

}


}
