% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem.r
\name{sem}
\alias{sem}
\title{Standard error of the mean (SEM)}
\usage{
sem(x, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector}

\item{na.rm}{logical. Should missing values be removed?}
}
\description{
Compute the standard error of the mean (SEM). The SEM is the standard deviation of the sample-mean's estimate of a population mean.
It therefore describes the accuracy of the calculation of a sample's mean.
If \code{na.rm} is \code{TRUE} then missing values are removed before computation proceeds.
}
\section{Details}{

The SEM of a zero-length vector (after removal of \code{NA}s if \code{na.rm = TRUE}) is not defined and gives an error.
The SEM of a length-one vector is \code{NA}.
}

\examples{
## Calculate mean and SEM for variable soil depth
mean(schedenenv$soil_depth)
sem(schedenenv$soil_depth)
}
\seealso{
\code{\link[stats]{sd}}
}
