% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{summary.gnr}
\alias{summary.gnr}
\title{Summarizing gross output function estimates}
\usage{
\method{summary}{gnr}(object, ...)
}
\arguments{
\item{object}{an object of class 'gnr'.}

\item{...}{currently not used.}
}
\value{
a list of class 'summary.gnr' containing 14 elements:
\itemize{
\item{\code{output_name}}{: the name of the output variable.}
\item{\code{fixed_names}}{: a vector of the names of fixed input variables.}
\item{\code{flex_name}}{: the name of the flexible input variable.}
\item{\code{data}}{: \code{data} returned by \code{\link[gnrprod]{gnrprod}}.}
\item{\code{data_name}}{: the name of \code{data}.}
\item{\code{fs_conv}}{: a boolean indicating if convergence was achieved in the first stage.}
\item{\code{ss_conv}}{: the convergence code of \code{\link[stats]{optim}} used in the second stage.}
\item{\code{productivity}}{: matrix of the estimated total productivity.}
\item{\code{fs_iter}}{: the number of iterations in the first stage.}
\item{\code{fs_SSR}}{: sum of squared residuals in the first stage.}
\item{\code{ss_iter}}{: the number of iterations in the second stage.}
\item{\code{ss_val}}{: the value of the objective function in the second stage.}
\item{\code{ss_iter}}{: the number of iterations in the second stage.}
\item{\code{ss_mes}}{: the convergence message in the second stage.}
}
}
\description{
Return a summary of the estimation routine for gross output functions from \code{\link[gnrprod]{gnrprod}}.
}
