% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnriv.R
\name{gnriv}
\alias{gnriv}
\title{Estimate fixed input elasticity and total productivity: Gandhi, Navarro, Rivers (GNR) lags as instruments; second stage}
\usage{
gnriv(object, control, ...)
}
\arguments{
\item{object}{object of class 'gnrflex'.}

\item{control}{an optional list of convergence settings. See \code{\link[gnrprod]{gnriv.control}} for listing.}

\item{...}{additional optional arguments passed to optim.}
}
\value{
a list of class 'gnriv' containing three elements:

\code{fixed_elas}: a numeric matrix of estimated elasticities of fixed inputs for each observation.

\code{productivity}: a numeric vector of estimated total productivity.

\code{control}: the list of convergence control parameters. See \code{\link[gnrprod]{gnriv.control}} for available parameters.
}
\description{
The \code{gnriv} function implements the second stage of the
GNR production function estimation routine, nonparametrically identifying
the fixed input elasticities of the production function and total
productivity. This function accepts an object of class 'gnrflex'. The
parameters are optimized using the function \code{\link[stats]{optim}}.

For details, see Gandhi, Navarro, and Rivers (2020).
}
\examples{
require(gnrprod)
data <- colombian
industry_311_flex <- gnrflex(output = "RGO", fixed = c("L", "K"),
                             flex = "RI", share = "share", id = "id",
                             time = "year", data = data,
                             control = list(degree = 2, maxit = 200))

industry_311_fixed <- gnriv(industry_311_flex,
                            control = list(trace = 1))
}
\references{
Gandhi, Amit, Salvador Navarro, and David Rivers. 2020. "On the Identification of Gross Output Production Functions." \emph{Journal of Political Economy}, 128(8): 2973-3016. \doi{10.1086/707736}.
}
