% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{anova.joint}
\alias{anova.joint}
\title{Anova for joint models}
\usage{
\method{anova}{joint}(object, object2, ...)
}
\arguments{
\item{object}{a joint model fit by the \code{joint} function. This should be \strong{nested}
in \code{object2}.}

\item{object2}{a joint model fit by the \code{joint} function. This should be more complex
than \code{object} whilst sharing the same survival sub-model.}

\item{...}{additional arguments (none used).}
}
\value{
A list of class \code{anova.joint} with elements \describe{

  \item{\code{mod0}}{the name of \code{object}.}
  \item{\code{l0}}{the log-likelihood of the nested model, i.e. fit under the null.}
  \item{\code{AIC0}}{AIC for \code{object}.}
  \item{\code{BIC0}}{BIC for \code{object}.}
  \item{\code{mod1}}{the name of \code{object2}.}
  \item{\code{l1}}{the log-likelihood under the alternative hypothesis.}
  \item{\code{AIC1}}{AIC for \code{object2}.}
  \item{\code{BIC1}}{BIC for \code{object2}.}
  \item{\code{LRT}}{likelihood ratio test statistic.}
  \item{\code{p}}{the p-value of \code{LRT}.}

}
}
\description{
Perform a likelihood ratio test between two (nested) \code{joint} models.
}
\examples{
\donttest{
rm(list=ls())
data(PBC)
# Compare quadratic vs linear time specification for log(serum bilirubin) -----
PBC$serBilir <- log(PBC$serBilir)
long.formulas1 <- list(serBilir ~ drug * time + (1 + time|id))
long.formulas2 <- list(serBilir ~ drug * (time + I(time^2)) + (1 + time + I(time^2)|id))
surv.formula <- Surv(survtime, status) ~ drug
family <- list('gaussian')
# Fit the two competing models (fit is nested in fit2) ------------------------
fit <- joint(long.formulas1, surv.formula, PBC, family, 
             control = list(verbose = FALSE))
fit2 <- joint(long.formulas2, surv.formula, PBC, family, control = list(verbose = FALSE))
anova(fit, fit2)
# Quadratic terms improve fit significantly. 
}
}
\seealso{
\code{\link{joint}} and \code{\link{logLik.joint}}.
}
\author{
James Murray (\email{j.murray7@ncl.ac.uk})
}
