% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{diagnostic_plot}
\alias{diagnostic_plot}
\title{Quantile residual diagnostic plot for a GMVAR model}
\usage{
diagnostic_plot(
  gmvar,
  type = c("all", "series", "ac", "ch", "norm"),
  maxlag = 10,
  wait_time = 4
)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{type}{which type of diagnostic plot should be plotted?
\itemize{
  \item{\code{"all"} all below sequentially.}
  \item{\code{"series"} the quantile residual time series.}
  \item{\code{"ac"} the quantile residual autocorrelation and cross-correlation functions.}
  \item{\code{"ch"} the squared quantile residual autocorrelation and cross-correlation functions.}
  \item{\code{"norm"} the quantile residual histogram with theoretical standard normal
    density (dashed line) and standard normal QQ-plots.}
}}

\item{maxlag}{the maximum lag considered in types \code{"ac"} and \code{"ch"}.}

\item{wait_time}{if \code{type == all} how many seconds to wait before showing next figure?}
}
\description{
\code{diagnostic_plot} plots a multivariate quantile residual diagnostic plot
  for either autocorrelation, conditional heteroskedasticity, or normality, or simply draws
  the quantile residual time series.
}
\details{
Auto- and cross-correlations (types \code{"ac"} and \code{"ch"}) are calculated with the function
 \code{acf} from the package \code{stats} and the plot method for class \code{'acf'} objects is employed.
}
\examples{
# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2), d=2 model:
params122 <- c(0.623, -0.129, 0.959, 0.089, -0.006, 1.006, 1.746,
 0.804, 5.804, 3.245, 7.913, 0.952, -0.037, -0.019, 0.943, 6.926,
 3.982, 12.135, 0.789)
mod122 <- GMVAR(data, p=1, M=2, params=params122)
diagnostic_plot(mod122, type="series")
diagnostic_plot(mod122, type="ac")

# GMVAR(2,2), d=2 model:
params222 <-  c(1.386, -0.765, 1.314, 0.145, 0.094, 1.292, -0.389,
 -0.070, -0.109, -0.281, 0.920, -0.025, 4.839, 1.005, 5.928, 1.248,
  0.077, -0.040, 1.266, -0.272, -0.074, 0.034, -0.313, 5.855, 3.570,
  9.838, 0.740)
mod222 <- GMVAR(data, p=2, M=2, params=params222)
diagnostic_plot(mod222, type="ch")
diagnostic_plot(mod222, type="norm")

# GMVAR(2,2), d=2 model with AR-parameters restricted to be
# the same for both regimes:
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
params222c <- c(1.031, 2.356, 1.786, 3.000, 1.250, 0.060, 0.036,
 1.335, -0.290, -0.083, -0.047, -0.356, 0.934, -0.152, 5.201, 5.883,
 3.560, 9.799, 0.368)
mod222c <- GMVAR(data, p=2, M=2, params=params222c, constraints=C_mat)
diagnostic_plot(mod222c, wait_time=0.1)
diagnostic_plot(mod222c, type="ac", maxlag=12)
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{profile_logliks}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{quantile_residual_tests}},
 \code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{cond_moment_plot}}, \code{\link[stats]{acf}},
  \code{\link[stats]{density}}, \code{\link{predict.gmvar}}
}
