% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{loglikelihood_int}
\alias{loglikelihood_int}
\title{Compute the log-likelihood of Gaussian Mixture Vector Autoregressive model}
\usage{
loglikelihood_int(data, p, M, params, conditional = TRUE,
  parametrization = c("intercept", "mean"), constraints = NULL,
  to_return = c("loglik", "mw", "mw_tplus1", "loglik_and_mw", "terms",
  "regime_cmeans", "total_cmeans", "total_ccovs"), check_params = TRUE,
  minval = NULL)
}
\arguments{
\item{data}{a matrix or class \code{'ts'} object with \code{d>1} columns. Each column is taken to represent
a single time series. \code{NA} values are not supported.}

\item{p}{a positive integer specifying the autoregressive degree of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{params}{a real valued vector specifying the parameter values.
\describe{
  \item{\strong{For regular models:}}{
    Should be size \eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
    ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
    \itemize{
      \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
      \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
      \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
    }
  }
  \item{\strong{For constrained models:}}{
    Should be size \eqn{((M(d+d(d+1)/2+1)+q-1)x1)} and have form
    \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\psi}}
    \eqn{,\sigma_{1},...,\sigma_{M},\alpha_{1},...,\alpha_{M-1})}, where:
    \itemize{
      \item \strong{\eqn{\psi}} \eqn{(qx1)} satisfies (\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}
      \strong{\eqn{\phi}}\eqn{_{M}) =} \strong{\eqn{C \psi}}. Here \strong{\eqn{C}} is \eqn{(Mpd^2xq)}
      constraint matrix.
    }
  }
}
Above \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of the \eqn{m}:th
mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component and
\eqn{\alpha_{m}} is the mixing weight parameter.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m,0}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks colums
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector.
The notations are in line with the cited article by \emph{Kalliovirta, Meitz and Saikkonen (2016)}.}

\item{conditional}{a logical argument specifying whether the conditional or exact log-likelihood function
should be used. Default is \code{TRUE}.}

\item{parametrization}{\code{"mean"} or \code{"intercept"} determining whether the model is parametrized with regime means \eqn{\mu_{m}} or
intercept parameters \eqn{\phi_{m,0}}, m=1,...,M. Default is \code{"intercept"}.}

\item{constraints}{a size \eqn{(Mpd^2 x q)} constraint matrix \strong{\eqn{C}} specifying general linear constraints
to the autoregressive parameters. We consider constraints of form
(\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}\strong{\eqn{\phi}}\eqn{_{M}) = }\strong{\eqn{C \psi}},
where \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p}) (pd^2 x 1), m=1,...,M}
contains the coefficient matrices and \strong{\eqn{\psi}} \eqn{(q x 1)} contains the constrained parameters.
For example, to restrict the AR-parameters to be the same for all regimes, set \strong{\eqn{C}}=
[\code{I:...:I}]\strong{'} \eqn{(Mpd^2 x pd^2)} where \code{I = diag(p*d^2)}.
Ignore (or set to \code{NULL}) if linear constraints should \strong{not} be employed.}

\item{to_return}{should the returned object be log-likelihood value, mixing weights, mixing weights including
value for \eqn{alpha_{m,T+1}}, a list containing log-likelihood value and mixing weights or
the terms \eqn{l_{t}: t=1,..,T} in the log-likelihood function (see \emph{KMS 2016, eq.(9)})? Or should
the regimewise conditional means, total conditional means, or total conditional covariance matrices
be returned? Default is the log-likelihood value (\code{"loglik"}).}

\item{check_params}{should it be checked that the parameter vector satisfies the model assumptions? Can be skipped to save
computation time if it does for sure. Default \code{TRUE}.}

\item{minval}{value that will be returned if the parameter vector does not lie in the parameter space
(excluding the identification condition).}
}
\value{
\describe{
  \item{By default:}{log-likelihood value of the specified GMVAR model,}
  \item{If \code{to_return=="mw"}:}{a size ((n_obs-p)xM) matrix containing the mixing weights: for m:th component in m:th column.}
  \item{If \code{to_return=="mw_tplus1"}:}{a size ((n_obs-p+1)xM) matrix containing the mixing weights: for m:th component in m:th column.
    The last row is for \eqn{\alpha_{m,T+1}}}.
  \item{If \code{to_return=="terms"}:}{a size ((n_obs-p)x1) numeric vector containing the terms \eqn{l_{t}}.}
  \item{if \code{to_return=="loglik_and_mw"}:}{a list of two elements. The first element contains the log-likelihood value and the
    second element contains the mixing weights.}
  \item{If \code{to_return=="regime_cmeans"}:}{an \code{[T-p, d, M]} array containing the regimewise conditional means
   (the first p values are used as the initial values).}
  \item{If \code{to_return=="total_cmeans"}:}{a \code{[T-p, d]} matrix containing the conditional means of the process
   (the first p values are used as the initial values).}
  \item{If \code{to_return=="total_ccov"}:}{an \code{[d, d, T-p]} array containing the conditional covariance matrices of the process
   (the first p values are used as the initial values).}
 }
}
\description{
\code{loglikelihood_int} computes the log-likelihood of GMVAR model.
}
\details{
Takes use of the function \code{dmvn} from the package \code{mvnfast} to cut down computation time.
  Values extremely close to zero are handled with the package \code{Brobdingnag}.
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
           \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
           \emph{Springer}.
 }
}
