% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateGMVAR.R
\name{simulateGMVAR}
\alias{simulateGMVAR}
\title{Simulate from GMVAR process}
\usage{
simulateGMVAR(gmvar, nsimu, init_values = NULL, ntimes = 1)
}
\arguments{
\item{gmvar}{object of class \code{'gmvar'}, generated by function \code{fitGMVAR()} or \code{GMVAR()}.}

\item{nsimu}{number of observations to be simulated.}

\item{init_values}{a size \eqn{(pxd)} matrix specifying the initial values to be used in the simulation, where
d is the number of time series in the system.
The \strong{last} row will be used as initial values for the first lag, the second last row for second lag etc. If not
specified, initial values will be generated from the stationary distribution.}

\item{ntimes}{how many sets of simulations should be done?}
}
\value{
Returns a list with...
  \describe{
    \item{\code{$sample}}{a size (\code{nsimu}\eqn{ x M}) matrix containing the simulated values.}
    \item{\code{$component}}{a numeric vector the containing the information from which mixture component each value is generated from.}
    \item{\code{$mixing_weights}}{a size (\code{nsimu}\eqn{ x M}) matrix containing the mixing weights corresponding to the
     sample so that \eqn{i}:th column is for \eqn{i}:th mixture component.}
  }
  \strong{Or if \code{ntimes>1}} returns a size (\code{nsimu}\eqn{ x d x }\code{ntimes}) 3D array containing the samples so that the \code{i}:th
  sample can be obtained from \code{[, , i]}.
}
\description{
\code{simulateGMVAR} simulates observations from GMVAR process defined by
  object of class \code{'gmvar'}.
}
\examples{
# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)
set.seed(1)

# GMVAR(1,2), d=2 process:
params122 <- c(0.623, -0.129, 0.959, 0.089, -0.006, 1.006, 1.746,
 0.804, 5.804, 3.245, 7.913, 0.952, -0.037, -0.019, 0.943, 6.926,
 3.982, 12.135, 0.789)
mod122 <- GMVAR(data, p=1, M=2, params=params122)
sim122 <- simulateGMVAR(mod122, nsimu=500)
plot.ts(sim122$sample)
ts.plot(sim122$mixing_weights, col=c("blue", "red"), lty=2)
plot(sim122$component, type="l")

# GMVAR(2,2), d=2 model with mean-parametrization:
params222 <- c(-11.904, 154.684, 1.314, 0.145, 0.094, 1.292, -0.389,
 -0.070, -0.109, -0.281, 0.920, -0.025, 4.839, 11.633, 124.983, 1.248,
  0.077, -0.040, 1.266, -0.272, -0.074, 0.034, -0.313, 5.855, 3.570,
  9.838, 0.740)
mod222 <- GMVAR(data, p=2, M=2, params=params222, parametrization="mean")
sim222 <- simulateGMVAR(mod222, nsimu=500)
plot.ts(sim222$sample)
ts.plot(sim222$mixing_weights, col=c("blue", "red"), lty=2)
plot(sim222$component, type="l")

# GMVAR(2,2), d=2 model with AR-parameters restricted to be
# the same for both regimes:
C_mat <- rbind(diag(2*2^2), diag(2*2^2))
params222c <- c(1.031, 2.356, 1.786, 3.000, 1.250, 0.060, 0.036,
 1.335, -0.290, -0.083, -0.047, -0.356, 0.934, -0.152, 5.201, 5.883,
 3.560, 9.799, 0.368)
mod222c <- GMVAR(data, p=2, M=2, params=params222c, constraints=C_mat)
sim222c <- simulateGMVAR(mod222c, nsimu=100,
             init_values=matrix(c(30, 30, 80, 80), nrow=2))
plot.ts(sim222c$sample)
ts.plot(sim222c$mixing_weights, col=c("blue", "red"), lty=2)
plot(sim222$component, type="l")
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
 }
}
