% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{random_covmat}
\alias{random_covmat}
\title{Create somewhat random VAR model error term covariance matrix}
\usage{
random_covmat(d, omega_scale)
}
\arguments{
\item{d}{number of time series in the system.}

\item{omega_scale}{a size \eqn{(dx1)} strictly positive vector specifying the scale and variability of the
random covariance matrices in random mutations. The covariance matrices are drawn from (scaled) Wishart distribution.
Expected values of the random covariance matrices are \code{diag(omega_scale)}. Standard deviations
of the diagonal elements are \code{sqrt(2/d)*omega_scale[i]}
and for non-diagonal elements they are \code{sqrt(1/d*omega_scale[i]*omega_scale[j])}.
Note that for \code{d>4} this scale may need to be chosen carefully. Default in \code{GAfit()} is
\code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}.}
}
\value{
Returns \eqn{(d(d+1)/2x1)} vector containing vech-vectorized covariance matrix \eqn{\Omega}.
}
\description{
\code{random_covmat} generates random VAR model \eqn{(dxd)} error term covariance matrix \eqn{\Omega}
  from (scaled) Wishart distribution.
}
