% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/svm.R
\name{predict.Rcpp_SVMClient}
\alias{predict.Rcpp_SVMClient}
\title{Predict using SVM object}
\usage{
\method{predict}{Rcpp_SVMClient}(object, x_test, decision.function = FALSE,
  ...)
}
\arguments{
\item{object}{Trained SVM object}

\item{x_test}{Unlabeled data, in one of the following formats:
\code{data.frame}, \code{data.matrix}, \code{SparseM::matrix.csr}, \code{Matrix::Matrix},
\code{slam::simple_triplet_matrix}}

\item{decision.function}{Uf \code{TRUE} returns SVMs decision function
(distance of a point from discriminant) instead of predicted labels, default: \code{FALSE}}

\item{...}{other arguments not used by this method.}
}
\description{
Returns predicted classes or distance to discriminative for provided test examples.
}
\examples{
\dontrun{
# firstly, SVM model needs to be trained
svm <- SVM(x, y, core="libsvm", kernel="linear", C=1)
# then we can use it to predict unknown samples
predcit(svm, x_test)
}
}

