% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{constructMask}
\alias{constructMask}
\title{Constructs a mask for a grid}
\usage{
constructMask(grid, method = "maxdist", maxval = NULL, x = NULL)
}
\arguments{
\item{grid}{a grid, see details for more info}

\item{method}{which construction method? currently one of 'maxdist', 'sillprop' or 'point2polygon'}

\item{maxval}{for maxdist and sillprop methods, maximum reference value}

\item{x}{extra information for the grid construction, see details}
}
\value{
a logical vector with as many elements as points in the grid, with TRUE for
those points within the mask, and FALSE for those outside the mask.
}
\description{
Constructs a mask for a grid
}
\details{
Method 'maxdist' defines the mask as all points within a maximum distance
(must be given in \code{maxval}) from the reference data (given in \code{x}: this is expected
to be the original complete data, with coordinates and variables). For method 'sillprop'
the mask is defined by those points which total kriging variance is below
a fixed proportion (given in \code{maxval}, default=0.99) of the total variogram
model sill (variogram model given in \code{x}, of class "variogramModelList").
In this method, the argument \code{grid} is expected to be the output of a cokriging
analysis. Finally, method 'point2poly' created the mask by taking the points internal
to a "SpatialPolygon" object (given in \code{x}).
}
\examples{
## with data.frame
x = 1:23
y = 1:29
xy = expand.grid(x=x, y=y)
xyz.df = data.frame(xy, z = rnorm(29*23)*ifelse(abs(xy$x-xy$y)<3, 1, NA)+(xy$x+xy$y)/2)
mask.df = constructMask(grid = xy, method = "maxdist", maxval = 3, x=xyz.df)
image(mask.df)
par(mfrow=c(1,1))
mask.df
xyz.df.masked = setMask(xyz.df, mask.df)
dim(xyz.df.masked)
summary(xyz.df.masked)
xyz.df.unmasked = unmask(xyz.df.masked)
dim(xyz.df.unmasked)
length(x)*length(y)
summary(xyz.df.unmasked)
## with SpatialGrid
library(sp)
library(magrittr)
xy.sp = sp::SpatialPoints(coords = xy)
meandiff = function(x) mean(diff(x))
xy.gt = GridTopology(c(min(x),min(y)), c(meandiff(x), meandiff(y)), c(length(x),length(y)))
aux = sp::SpatialPixelsDataFrame(grid = xy.gt, data=xyz.df, points = xy.sp)
xyz.sgdf = as(aux, "SpatialGridDataFrame")
image_cokriged(xyz.sgdf, ivar="z")
par(mfrow=c(1,1))
ms = function(x) sortDataInGrid(x, grid=xy.gt)
mask.gt = constructMask(grid = xy.gt, method = "maxdist", maxval = 3, x=xyz.sgdf)
image(x,y,matrix(ms(xyz.sgdf@data$z), nrow=23, ncol=29))  
image(x,y,matrix(ms(mask.gt), nrow=23, ncol=29))  
image(mask.gt)
par(mfrow=c(1,1))
xyz.sgdf.masked = setMask(x = xyz.sgdf, mask = mask.gt)
getMask(xyz.sgdf.masked)
image(x,y,matrix(ms(xyz.sgdf@data$z), nrow=23, ncol=29))  
points(xyz.sgdf.masked@coords)
}
\seealso{
Other masking functions: 
\code{\link{getMask}()},
\code{\link{print.mask}()},
\code{\link{setMask}()},
\code{\link{unmask}()}
}
\concept{masking functions}
