% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{ndirections}
\alias{ndirections}
\alias{ndirections.default}
\alias{ndirections.azimuth}
\alias{ndirections.azimuthInterval}
\alias{ndirections.logratioVariogramAnisotropy}
\alias{ndirections.logratioVariogram}
\alias{ndirections.gmEVario}
\alias{ndirections.gstatVariogram}
\title{Number of directions of an empirical variogram}
\usage{
ndirections(x)

\method{ndirections}{default}(x)

\method{ndirections}{azimuth}(x)

\method{ndirections}{azimuthInterval}(x)

\method{ndirections}{logratioVariogramAnisotropy}(x)

\method{ndirections}{logratioVariogram}(x)

\method{ndirections}{gmEVario}(x)

\method{ndirections}{gstatVariogram}(x)
}
\arguments{
\item{x}{empirical variogram object}
}
\value{
Generic function. It provides the
number of directions at which an empirical variogram was computed
}
\description{
Returns the number of directions at which an empirical variogram was computed
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: generic method

\item \code{azimuth}: method for objects of class "azimuth" (vectors of single angles)

\item \code{azimuthInterval}: method for objects of class "azimuthInterval" (data.frames of intervals for angles)

\item \code{logratioVariogramAnisotropy}: method for empirical logratio variograms with anisotropy

\item \code{logratioVariogram}: method for empirical logratio variograms without anisotropy

\item \code{gmEVario}: method for empirical gmGeostats variograms

\item \code{gstatVariogram}: method for empirical gstat variograms
}}

\seealso{
\code{\link[=logratioVariogram]{logratioVariogram()}}, \code{\link[gstat:variogram]{gstat::variogram()}}

Other gmEVario functions: 
\code{\link{as.gmEVario}()},
\code{\link{gsi.EVario2D}()},
\code{\link{gsi.EVario3D}()},
\code{\link{plot.gmEVario}()},
\code{\link{variogramModelPlot}()}

Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{[[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{length.gmCgram}()},
\code{\link{plot.gmCgram}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
\concept{gmEVario functions}
