% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{optimalCutoff}
\alias{optimalCutoff}
\title{Compute the optimal probability cutoff score}
\usage{
optimalCutoff(
  actuals,
  predictedScores,
  optimiseFor = "misclasserror",
  returnDiagnostics = FALSE
)
}
\arguments{
\item{actuals}{The actual binary flags for the response variable. It can take a numeric vector containing values of either 1 or 0, where 1 represents the 'Good' or 'Events' while 0 represents 'Bad' or 'Non-Events'.}

\item{predictedScores}{The prediction probability scores for each observation. If your classification model gives the 1/0 predcitions, convert it to a numeric vector of 1's and 0's.}

\item{optimiseFor}{The maximization criterion for which probability cutoff score needs to be optimised. Can take either of following values: "Ones" or "Zeros" or "Both" or "misclasserror"(default). If "Ones" is used, 'optimalCutoff' will be chosen to maximise detection of "One's". If 'Both' is specified, the probability cut-off that gives maximum Youden's Index is chosen. If 'misclasserror' is specified, the probability cut-off that gives minimum mis-clasification error is chosen.}

\item{returnDiagnostics}{If TRUE, would return additional diagnostics such as 'sensitivityTable', 'misclassificationError', 'TPR', 'FPR' and 'specificity' for the chosen cut-off.}
}
\value{
The optimal probability score cutoff that maximises a given criterion. If 'returnDiagnostics' is TRUE, then the following items are returned in a list:
}
\description{
Compute the optimal probability cutoff score
}
\details{
This function was obtained from the InformationValue R package (\url{https://github.com/selva86/InformationValue}).
}
\keyword{internal}
