% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{anova.overglm}
\alias{anova.overglm}
\title{Comparison of nested Negative Binomial and Beta-Binomial Regression Models}
\usage{
\method{anova}{overglm}(
  object,
  ...,
  test = c("wald", "lrt", "score", "gradient"),
  verbose = TRUE
)
}
\arguments{
\item{object}{an object of the class overglm which is obtained from the fit of a negative binomial or beta-binomial model.}

\item{...}{another objects of the class overglm which are obtained from the fit of negative binomial or beta-binomial models.}

\item{test}{an (optional) character string indicating the required test. The available options are: Wald ("wald"), Rao's score ("score"), likelihood ratio ("lrt") and Terrell's gradient ("gradient") tests. By default, \code{test} is set to be "wald".}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A matrix with three columns which contains the following:
\itemize{
\item \code{Chi:}{ The value of the statistic of the test.}
\item \code{Df:}{ The number of degrees of freedom.}
\item \code{Pr(>Chi):}{ The \emph{p}-value of the test computed using the Chi-square distribution.}
}
}
\description{
Allows to compare nested negative binomial and beta-binomial regression models using Wald, score, gradient and likelihood ratio tests.
}
\details{
The Wald, Rao's score and Terrell's gradient tests are performed using the observed Fisher information matrix.
}
\examples{
## Example 1
fit1 <- overglm(cbind(cells,200-cells) ~ tnf, family="bb(logit)", data=cellular)
fit2 <- update(fit1, . ~ . + ifn)
fit3 <- update(fit2, . ~ . + tnf:ifn)
anova(fit1, fit2, fit3, test="wald")
anova(fit1, fit2, fit3, test="score")
anova(fit1, fit2, fit3, test="lrt")
anova(fit1, fit2, fit3, test="gradient")

## Example 2
fit1 <- overglm(infections ~ frequency, family="nb1(log)", data=swimmers)
fit2 <- update(fit1, . ~ . + location)
fit3 <- update(fit2, . ~ . + age)
fit4 <- update(fit3, . ~ . + gender)
anova(fit1, fit2, fit3, fit4, test="wald")
anova(fit1, fit2, fit3, fit4, test="score")
anova(fit1, fit2, fit3, fit4, test="lrt")
anova(fit1, fit2, fit3, fit4, test="gradient")
}
\references{
Buse A. (1982) The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note. \emph{The American Statistician} 36, 153 - 157.

Terrell G.R. (2002) The gradient statistic. \emph{Computing Science and Statistics} 34, 206 – 215.
}
