% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested.glmnetr_230508.R
\name{nested.glmnetr}
\alias{nested.glmnetr}
\title{Using nested cross validation, describe and compare fits of various cross validation informed machine learning models.}
\usage{
nested.glmnetr(
  xs,
  start = NULL,
  y_,
  event = NULL,
  family = "gaussian",
  steps_n = 0,
  folds_n = 10,
  dolasso = 1,
  doxgb = 0,
  doann = 0,
  dorpart = 0,
  dostep = 0,
  doaic = 0,
  ensemble = 0,
  method = "loglik",
  lambda = NULL,
  gamma = NULL,
  relax = TRUE,
  limit = 1,
  fine = 0,
  track = 0,
  seed = NULL,
  foldid = NULL,
  ties = "efron",
  stratified = 1,
  time = NULL,
  ...
)
}
\arguments{
\item{xs}{predictor input - an n by p matrix, where n (rows) is sample size, and p (columns) 
the number of predictors.  Must be in matrix form for complete data, no NA's, no Inf's, etc.,
and not a data frame.}

\item{start}{optional start times in case of a Cox model.  - class numeric of length same as number of patients (n)}

\item{y_}{dependent variable as a vector: time, or stop time for Cox model, Y_ 0 or 1 for binomal (logistic), numeric for gaussian. 
Must be a vector of length same as number of sample size.}

\item{event}{event indicator, 1 for event, 0 for census, Cox model only.
Must be a numeric vector of length same as sample size.}

\item{family}{model family, "cox", "binomial" or "gaussian" (default)}

\item{steps_n}{number of steps done in stepwise regression fitting}

\item{folds_n}{generally the number of folds for each level of cross validation.  If 
a vector of length 2 the first element indicates the number of folds for cross 
validation, and the second entry can take the value 1 to indicate
that no nested cross validation is to be performed.  In this case the function 
will only derive the models based upon the full data set.  This is useful for the 
"lasso informed" Artificial Neural Network (ANN) models which are based upon 
both a lasso fit and an ANN fit. See the predict_ann_tab() function regarding
getting predicteds for this "lasso informed" models from a nested.glmnetr() output.}

\item{dolasso}{fit and do cross validation for lasso model, 0 or 1}

\item{doxgb}{1 to fit and evaluate cross validation informed XGBoost 
model, and the number of folds used in model derivation will be the same as 
folds_n.  0 (default) for no XGBoost model fits.  An integer > 1 to specify 
number of folds used in model fit other than folds_n. If length(doxgb) > 1 then the
maximum number of rounds (nrounds) when training the xgb model is set to doxgb[2], 
where the default is 1000.}

\item{doann}{fit and evaluate a cross validation informed Artificial Neural Network 
(ANN) model with two hidden levels.  1 for yes, 0 for no (default). To take some 
control over the ANN fit specify a list can be passed as the arguement for doann.  The
list can have elements $epochs, $epochs2, $myler, $myler2, $eppr, $eppr2, $lenv1, $lenz2, 
$actv, $drpot, $wd, wd2, l1, l12, $fold_n, $minloss and $gotoend.  These different 
values are then passed to the ann_tab_cv() function, with the meanings described 
in the help for that function, with some exception.  When there are two similar 
values like $epoch and $epoch2epoch the first applies to the ANN fits without transfer 
learning and the second to the models fit with transfer learning from the lasso 
model.  Elements of this list left unspecified will take default values.}

\item{dorpart}{fit and do a nested cross validation for an RPART model.  As rpart() does its
own approximation for cross validation there is no new functions for RPART itself.}

\item{dostep}{fit and do cross validation for stepwise regression fit, 0 or 1, 
as discussed in James, Witten, Hastie and Tibshirani, 2nd edition.}

\item{doaic}{fit and do cross validation for AIC fit, 0 or 1.
This is provided primarily as a reference.}

\item{ensemble}{fit a sort of ensemble model by fitting a lasso model and then using its 
predictions as a) an additional term in the feature set or b) an offset 
(base_margin in XGBoost) to the XGBoost model.  This is a vector of length 3, with
position 1 indicating if the "standard" XGBoost model is to be fit, position 2 indicating 
whether the lasso predictor is be included as an additional feature, and position 3 indicating whether 
the lasso predictor should be included as an offset. 1 for yes, 0 (default) for no.}

\item{method}{method for choosing model in stepwise procedure, "loglik" or "concordance".
Other procedures use the "loglik".}

\item{lambda}{lambda vector for the lasso fit}

\item{gamma}{gamma vector for the relaxed lasso fit, default is c(0,0.25,0.5,0.75,1)}

\item{relax}{fit the relaxed lasso model when fitting a lasso model}

\item{limit}{limit the small values for lambda after the initial fit.  This 
will have minimal impact on the cross validation.  Default is 2 for moderate 
limitation, 1 for less limitation, 0 for none.}

\item{fine}{use a finer step in determining lambda.  Of little value unless one 
repeats the cross valiaiton many times to more finely tune the hyper paramters.  
See the 'glmnet' package documentation}

\item{track}{track progress by printing to console elapsed and split times}

\item{seed}{a seed for set.seed() to assure one can get the same results twice.  If NULL 
the program will generate a random seed.  Whether specified or NULL, the seed is stored in the output
object for future reference.}

\item{foldid}{a vector of integers to associate each record to a fold.  Should be integers between 1 and folds_n.
These will only be used in the outer folds.}

\item{ties}{method for handling ties in Cox model for relaxed model component.  Default 
is "efron", optionally "breslow".  For penalized fits "breslow" is 
always used as in the 'glmnet' package.}

\item{stratified}{1 to generate fold IDs stratified on outcome or event indicators for the binomial or Cox model.}

\item{time}{track progress by printing to console elapsed and split times.  Suggested to use
track option instead as time option will be discontinued.}

\item{...}{additional arguments that can be passed to glmnet()}
}
\value{
- Cross validation informed LASSO, GBM, RPART or STEPWISE model fits, 
together with estimates of model performance derived using nested cross validation.
}
\description{
Performs a nested cross validation for cross validation informed 
relaxed lasso, (artificial) Neural Network (ANN) with two hidden layers, Gradient 
Boosting Machine (GBM), Recursive Partitioning (RPART) and step wise regression.  That is
hyper parameters for all these models are informed by cross validation (CV), and a second 
layer of CV is used to evaluate the performance of these CV informed model fits.  For
step wise regression CV is used to inform either ap value for entry or degress of 
freedom (df) for the final model shoice.  For input 
we require predictors (features) to be in numeric matrix format with no missing 
values.  This is similar to how the glmnet package expects predictors.  For 
survival data we allow input of start time as an option, and require stop time, 
and an event indicator, 1 for event and 0 for censoring, as separate terms. This
may seem unorthodox as it might seem simpler to accept a Surv() object as input.  However
the XGBoost routines require a different data format with only a "stop time" 
variable, taking a positive value to indicate being associated with an event, and 
the negative of the time when associated with a censoring.  Further with XGBoost 
we combine both the predictors and outcome (or label) in an xgb.DMatrix() object.  Further
teh evaluation of the loss functinwhen fitting a neural network model also requires
the individual vectors for time to event and the event indicator and not a Surv()
object.  Instead of translating between these formats we take as input the individual 
data elements and construct whatever object is needed for the particular model.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$y_ 
# for this example we use a small number for folds_n to shorten run time 
nested.glmnetr.fit = nested.glmnetr( xs, NULL, y_, NULL, family="gaussian", folds_n=3)
plot(nested.glmnetr.fit) 
plot(nested.glmnetr.fit, coefs=TRUE) 
summary(nested.glmnetr.fit) 
summary(nested.glmnetr.fit, cvfit=TRUE) 
}

}
\seealso{
\code{\link{glmnetr}} , \code{\link{cv.glmnetr}}  , \code{\link{glmnetr.simdata}} , \code{\link{summary.nested.glmnetr}} , \code{\link{glmnetr.compcv}} , \code{\link{plot.nested.glmnetr}} , \code{\link{predict_ann_tab}}
}
