% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\docType{package}
\name{glmglrt}
\alias{glmglrt}
\title{glmglrt: GLRT P-Values in Generalized Linear Models}
\description{
This package has been developed to provide Generalized Likelihood Ratio Tests (GLRT)
also known as Likelihood Ratio Tests (LRT) to Generalized Linear Models (GLMs).
The \link{stats} package do support LRT P-values with \code{\link[stats:anova]{anova}} and
derived confidence intervals with \code{confint()}, but provides Wald's P-values with
the \code{\link[stats:summary.glm]{summary}} function.
This is unfortunate for two reasons: Wald's P-values may be inconsistent with profile-likelihood
confidence intervals and Wald's P-values, on small samples are more biased than LRT P-values, for
non-gaussian models. The \code{\link[stats:anova]{anova}} function is not as simple as
\code{\link[stats:summary.glm]{summary}}, since it requires manually fitting two models.
}
\section{Summary function}{

This package provides a way to override (see \link{override_summary}) the standard \code{\link[stats:summary.glm]{summary.glm}} function
by a \code{\link{summarylr}} function that provides LRT and/or Rao's score P-values.
}

\section{Functions to estimate contrasts}{

It also provides functions \code{\link{estimate_contrast}}, \code{\link{confint_contrast}} and \code{\link{p_value_contrast}}
to estimate contrasts of coefficients of GLMs with LRT, Rao's and Wald's hypothesis tests and confidence intervals
This is an alternative to \code{\link[multcomp:glht]{multcomp::glht}} without
Wald's approximation ! It also provides a less powerful \code{\link{p_value.glm}} method for the S3 generic
\link[parameters:p_value]{parameters::p_value}. It also extends this S3 generic for a variety
of models as \code{\link{p_value.default}}. That time, the only method supported for all models, is Wald's method.
}

