% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{predict.glmaag}
\alias{predict.glmaag}
\title{Prediction for glmaag}
\usage{
\method{predict}{glmaag}(object, x, lam1, lam2, type = "link",
  cutp = 0.5, ...)
}
\arguments{
\item{object}{fitted glmaag object}

\item{x}{The new dataset to be predicted, do training prediction if x is missing}

\item{lam1}{lambda1 sequence for prediction, must be within the fitted model}

\item{lam2}{lambda2 sequence for prediction, must be within the fitted model}

\item{type}{type of prediction (can be "link", "reponse"), ignored for Gaussian model. "link" is the linear predicted score, "response" is the predicted probability for logistic model and relative risk for Cox model}

\item{cutp}{the cut off value for binary outcome, default to be 0.5}

\item{...}{\dots}
}
\value{
predicted values
}
\description{
Prediction using glmaag model
}
\examples{
data(sampledata)
data(L0)
y <- sampledata$Y_Gau
x <- sampledata[, -(1:3)]
mod <- glmaag(y, x, L0)
pp <- predict(mod)
}
