% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glca.gof.R
\name{glca.gof}
\alias{glca.gof}
\title{Goodness of Fit Tests for Fitted \code{glca} Model}
\usage{
glca.gof(object, object2 = NULL, test = NULL, nboot = 25,
  random.seed = NULL, maxiter = 500, eps = 1e-05, verbose = TRUE)
}
\arguments{
\item{object}{an object of "\code{glca}", usually, a result of a call to \code{glca}}

\item{object2}{an optional object of "\code{glca}" to be compared with \code{object}}

\item{test}{a character string indicating type of test (chi-square test or bootstrap) to obtain the p-value for goodness of fit test (\code{"chisq"} or \code{"boot"})}

\item{nboot}{number of bootstrap samples, only used when \code{test = "boot"}}

\item{random.seed}{random seed to have the equivalent solution for every bootstrap trials}

\item{maxiter}{an integer for maximum number of iteration for bootstrap sample}

\item{eps}{positive convergence tolerance for bootstrap sample}

\item{verbose}{an logical value for whether or not to print the result of a function's execution}
}
\value{
\item{criteria}{a table with model fit criteria}
\item{dev.table}{a table with deviance statistic and bootstrap p-value}
\item{boot}{a list of LRT statistics from each bootstrap sample}
}
\description{
Provides AIC, BIC, and deviance statitistic for goodness of fit test for the fitted model. Given \code{object2}, the function computes the log-likelihood ratio (LRT) statisic for comparing the goodness of fit for two models. The bootstrap p-value can be obtained from the empirical distribution of LRT statistic by choosing \code{test = "boot"}.
}
\examples{
## Example 1.
## Model selection between two LCA models with different number of latent classes.
data(gss)
class2 = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE) ~ 1,
              data = gss, nclass = 2)
class3 = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE) ~ 1,
              data = gss, nclass = 3)

glca.gof(class2, class3)
\dontrun{glca.gof(class2, class3, test = "chisq")}
\dontrun{glca.gof(class2, class3, test = "boot")}

## Example 2.
## Model selection between two MLCA models with different number of latent clusters.
cluster2 = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE) ~ 1,
                group = REGION, data = gss, nclass = 3, ncluster = 2, na.rm = TRUE)
cluster3 = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE) ~ 1,
                group = REGION, data = gss, nclass = 3, ncluster = 3, na.rm = TRUE)

glca.gof(cluster2, cluster3)
\dontrun{glca.gof(cluster2, cluster3, test = "chisq")}
\dontrun{glca.gof(cluster2, cluster3, test = "boot")}

\donttest{
## Example 3.
## MGLCA model selection under the measurement (invariance) assumption across groups.
measInv = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE) ~ 1,
               group = SEX, data = gss, nclass = 3)
measVar = glca(item(ABDEFECT, ABHLTH, ABRAPE, ABPOOR, ABSINGLE) ~ 1,
               group = SEX, data = gss, nclass = 3, measure.inv = FALSE)

glca.gof(measInv, measVar)
\dontrun{glca.gof(measInv, measVar, test = "chisq")}
\dontrun{glca.gof(measInv, measVar, test = "boot")}
}
}
\references{
Akaike, H. (1974) A new look at the statistical model identification. \emph{IEEE Transactions on Automatic Control}, \bold{19}, 716–723. \doi{10.1109/tac.1974.1100705}

Schwarz, G. (1978) Estimating the dimensions of a model. \emph{The Annals of Statistics}, \bold{6}, 461–464. \doi{10.1214/aos/1176344136}

Langeheine, R., Pannekoek, J., and van de Pol, F. (1996) Bootstrapping goodness-of-fit measures in categorical data analysis. \emph{Sociological Methods and Research}. \bold{24}. 492-516. \doi{10.1177/0049124196024004004}
}
\seealso{
\code{\link{glca}} \code{\link{gss}}
}
\author{
Youngsun Kim
}
