% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_install_packages.R
\name{gh_install_packages}
\alias{gh_install_packages}
\alias{githubinstall}
\title{Install Packages from GitHub}
\usage{
gh_install_packages(packages, ask = TRUE, ref = "master",
  build_vignettes = FALSE, dependencies = NA, verbose = TRUE,
  quiet = !verbose, lib = NULL, ...)

githubinstall(packages, ask = TRUE, ref = "master",
  build_vignettes = FALSE, dependencies = NA, verbose = TRUE,
  quiet = !verbose, lib = NULL, ...)
}
\arguments{
\item{packages}{character vector of the names of the packages.
You can specify \code{ref} argument (see below) using \code{package_name[@ref|#pull]}.
If both are specified, the values in repo take precedence.}

\item{ask}{logical. Indicates ask to confirm before install.}

\item{ref}{character vector. Desired git reference. 
Could be a commit, tag, or branch name, or a call to \code{\link{github_pull}}. 
Defaults to "master".}

\item{build_vignettes}{logical. If \code{TRUE}, will build vignettes.}

\item{dependencies}{logical. Indicating to also install uninstalled packages which the packages depends on/links to/suggests. 
See argument dependencies of \code{\link{install.packages}}.}

\item{verbose}{logical. Indicating to print details of package building and installation. Dfault is \code{TRUE}.}

\item{quiet}{logical. Not \code{verbose}.}

\item{lib}{character vector giving the library directories where to install the packages. 
Recycled as needed. Defaults to the first element of \code{\link{.libPaths}()}.}

\item{...}{additional arguments to control installation of package, passed to \code{\link{install_github}}.}
}
\value{
TRUE if success.
}
\description{
Install Packages from GitHub
}
\details{
\code{githubinstall()} is an alias of \code{gh_install_packages()}.
}
\examples{
\dontrun{
gh_install_packages("AnomalyDetection")
githubinstall("AnomalyDetection")
}

}

