% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.r
\name{config}
\alias{config}
\title{Config}
\usage{
config(repo = NULL, global = FALSE, user.name, user.email, ...)
}
\arguments{
\item{repo}{The \code{repository}. Default is NULL.}

\item{global}{Write option(s) to global configuration
file. Default is FALSE.}

\item{user.name}{The user name. Use NULL to delete the entry}

\item{user.email}{The e-mail address. Use NULL to delete the entry}

\item{...}{Additional options to write or delete from the
configuration.}
}
\value{
S3 class \code{git_config}. When writing options, the
configuration is returned invisible.
}
\description{
Config file management. To display the configuration variables,
call method \code{config} without the \code{user.name},
\code{user.email} or \code{...} options.
}
\details{
There are two ways git2r can find the local repository when
writing local options (1) Use the \code{repo} argument. (2) If the
\code{repo} argument is \code{NULL} but the current working
directory is inside the local repository, then \code{git2r} uses
that repository.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern = "git2r-")
dir.create(path)
repo <- init(path)

## Set user name and email.
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Display configuration
config(repo)

## Delete user email.
config(repo, user.email = NULL)

## Display configuration
config(repo)
}
}

