% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tree.r
\docType{methods}
\name{tree}
\alias{tree}
\alias{tree,git_commit-method}
\alias{tree,git_stash-method}
\title{Tree}
\usage{
tree(object)

\S4method{tree}{git_commit}(object)

\S4method{tree}{git_stash}(object)
}
\arguments{
\item{object}{the \code{commit} or \code{stash} object}
}
\value{
A S4 class git_tree object
}
\description{
Get the tree pointed to by a commit or stash.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a first user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

tree(commits(repo)[[1]])
summary(tree(commits(repo)[[1]]))
}
}
\keyword{methods}

