% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rearrangeFiles.R
\name{rearrangeFiles}
\alias{rearrangeFiles}
\title{Rearrange GIMMS files by date}
\usage{
rearrangeFiles(x = NULL, dsn = getwd(), pattern = "^geo", ...)
}
\arguments{
\item{x}{Character. Vector of (local or online) filepaths. If \code{NULL},
\code{dsn} will be searched for available files via pattern matching.}

\item{dsn}{Character. Path to look for GIMMS data. If not supplied and
\code{is.null(fls)}, this argument defaults to the current working directory.}

\item{pattern}{Character. A regular expression passed on to
\code{\link{list.files}}.}

\item{...}{Further arguments passed on to \code{\link{list.files}}.}
}
\value{
A vector of filepaths arranged in ascending order of time.
}
\description{
Rearrange a vector of GIMMS files in ascending order of time. If no file
vector is supplied, the function will look for compatible files in the
current working directory.
}
\examples{
## latest version of files inventory
gimms_files <- updateInventory()
head(gimms_files)

## re-arrange vector with available files according to date
gimms_files_arr <- rearrangeFiles(gimms_files)
head(gimms_files_arr)

## (or simply use the two-in-one solution)
gimms_files <- updateInventory(sort = TRUE)
}
\author{
Florian Detsch
}
\seealso{
\code{\link{list.files}}
}

