% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_token.R
\name{gh_token}
\alias{gh_token}
\title{Return the local user's GitHub Personal Access Token (PAT)}
\usage{
gh_token(api_url = NULL)
}
\arguments{
\item{api_url}{GitHub API URL. Defaults to the \code{GITHUB_API_URL} environment
variable, if set, and otherwise to \url{https://api.github.com}.}
}
\value{
A string of characters, if a PAT is found, or the empty
string, otherwise. For convenience, the return value has an S3 class in
order to ensure that simple printing strategies don't reveal the entire
PAT.
}
\description{
If gh can find a personal access token (PAT) via \code{gh_token()}, it includes
the PAT in its requests. Some requests succeed without a PAT, but many
require a PAT to prove the request is authorized by a specific GitHub user. A
PAT also helps with rate limiting. If your gh use is more than casual, you
want a PAT.

gh calls \code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_get()}} with the \code{api_url}, which checks session
environment variables and then the local Git credential store for a PAT
appropriate to the \code{api_url}. Therefore, if you have previously used a PAT
with, e.g., command line Git, gh may retrieve and re-use it. You can call
\code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_get()}} directly, yourself, if you want to see what is
found for a specific URL. If no matching PAT is found,
\code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_get()}} errors, whereas \code{gh_token()} does not and,
instead, returns \code{""}.

See GitHub's documentation on \href{https://docs.github.com/en/github/authenticating-to-github/creating-a-personal-access-token}{Creating a personal access token},
or use \code{usethis::create_github_token()} for a guided experience, including
pre-selection of recommended scopes. Once you have a PAT, you can use
\code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_set()}} to add it to the Git credential store. From that
point on, gh (via \code{\link[gitcreds:gitcreds_get]{gitcreds::gitcreds_get()}}) should be able to find it
without further effort on your part.
}
\examples{
\dontrun{
gh_token()

format(gh_token())

str(gh_token())
}
}
