% Generated by roxygen2 (4.0.2): do not edit by hand
\name{input_select}
\alias{input_checkboxgroup}
\alias{input_radiobuttons}
\alias{input_select}
\title{Create interactive control to select one (or more options) from a list.}
\usage{
input_select(choices, selected = NULL, multiple = FALSE, label = "",
  id = rand_id("select_"), map = identity, selectize = FALSE)

input_radiobuttons(choices, selected = NULL, label = "",
  id = rand_id("radio_"), map = identity)

input_checkboxgroup(choices, selected = NULL, label = "",
  id = rand_id("radio_"), map = identity)
}
\arguments{
\item{choices}{List of values to select from. If elements of the list are
named then that name rather than the value is displayed to the user.}

\item{selected}{The initially selected value (or multiple values if
\code{multiple = TRUE}). If not specified then defaults to the first value
for single-select lists and no values for multiple select lists.}

\item{multiple}{Is selection of multiple items allowed?}

\item{label}{Display label for the control, or \code{NULL}}

\item{id}{A unique identifier for this input. Usually generated
automatically.}

\item{map}{A function with single argument \code{x}, the value of the
control on the client. Returns a modified value.}

\item{selectize}{Whether to use \pkg{selectize.js} or not.}
}
\description{
\itemize{
 \item \code{input_radiobuttons} only ever selects one value
 \item \code{input_checkboxgroup} can alway select multiple values
 \item \code{input_select} can select only one if \code{multiple = FALSE},
   otherwise the user can select multiple by using modifier keys
}
}
\examples{
# Dropdown
input_select(c("a", "b", "c"))
input_select(c("a", "b", "c"), multiple = TRUE)
input_select(c("a", "b", "c"), selected = "c")

# If you want to select variable names, you need to convert
# the output of the input to a name with map so that they get
# computed correctly
input_select(names(mtcars), map = as.name)

# Radio buttons
input_radiobuttons(choices = c("Linear" = "lm", "LOESS" = "loess"),
                   label = "Model type")
input_radiobuttons(choices = c("Linear" = "lm", "LOESS" = "loess"),
                   selected = "loess",
                   label = "Model type")

# Used in layer_model_predictions
mtcars \%>\% ggvis(~wt, ~mpg) \%>\%
  layer_model_predictions(model = input_radiobuttons(
    choices = c("Linear" = "lm", "LOESS" = "loess"),
    selected = "loess",
    label = "Model type"))

# Checkbox group
mtcars \%>\% ggvis(x = ~wt, y = ~mpg) \%>\%
  layer_points(
    fill := input_checkboxgroup(
      choices = c("Red" = "r", "Green" = "g", "Blue" = "b"),
      label = "Point color components",
      map = function(val) {
        rgb(0.8 * "r" \%in\% val, 0.8 * "g" \%in\% val, 0.8 * "b" \%in\% val)
      }
    )
  )
}
\seealso{
Other interactive input: \code{\link{input_checkbox}};
  \code{\link{input_numeric}}, \code{\link{input_text}};
  \code{\link{input_slider}}
}

