% Generated by roxygen2 (4.0.2): do not edit by hand
\name{compute_count}
\alias{compute_count}
\title{Count data at each location}
\usage{
compute_count(x, x_var, w_var = NULL)
}
\arguments{
\item{x}{Dataset-like object to count. Built-in methods for data frames,
grouped data frames and ggvis visualisations.}

\item{x_var,w_var}{Names of x and weight variables.}
}
\value{
A data frame with columns:
 \item{count_}{the number of points}
 \item{x_}{the x value where the count was made}

The width of each "bin" is set to the resolution of the data -- that is, the
smallest difference between two x values.
}
\description{
Count data at each location
}
\examples{
mtcars \%>\% compute_count(~cyl)

# Weight the counts by car weight value
mtcars \%>\% compute_count(~cyl, ~wt)

# If there's one weight value at each x, it effectively just renames columns.
pressure \%>\% compute_count(~temperature, ~pressure)
# Also get the width of each bin
pressure \%>\% compute_count(~temperature, ~pressure) \%>\% compute_align(~x_)

# It doesn't matter whether you transform inside or outside of a vis
mtcars \%>\% compute_count(~cyl, ~wt) \%>\%
  compute_align(~x_) \%>\%
  ggvis(x = ~xmin_, x2 = ~xmax_, y = ~count_, y2 = 0) \%>\%
  layer_rects()

mtcars \%>\%
  ggvis(x = ~xmin_, x2 = ~xmax_, y = ~count_, y2 = 0) \%>\%
  compute_count(~cyl, ~wt) \%>\%
  compute_align(~x_) \%>\%
  layer_rects()
}
\seealso{
\code{\link{compute_bin}} For counting cases within ranges of
  a continuous variable.

\code{\link{compute_align}} For calculating the "width" of data.
}

