% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{theme_calc}
\alias{theme_calc}
\title{Theme Calc}
\usage{
theme_calc(base_size = 10, base_family = "sans")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Theme similar to the default settings of LibreOffice Calc charts.
}
\examples{
library("ggplot2")

p <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, colour = factor(gear))) +
     facet_wrap(~am) + theme_calc()
p + scale_color_calc()
q <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, shape = factor(gear))) +
     facet_wrap(~am) +
     theme_calc()
q + scale_shape_calc()
}
