% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/economist.R
\name{theme_economist}
\alias{theme_economist}
\alias{theme_economist_white}
\title{ggplot color theme based on the Economist}
\usage{
theme_economist(base_size = 10, base_family = "sans", horizontal = TRUE,
  dkpanel = FALSE, stata = FALSE)

theme_economist_white(base_size = 11, base_family = "sans",
  gray_bg = TRUE, horizontal = TRUE)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{horizontal}{\code{logical}. Horizontal axis lines?}

\item{dkpanel}{\code{logical} Darker background for panel region?}

\item{stata}{\code{logical} Use RGB values from Stata's
economist scheme.}

\item{gray_bg}{\code{logical} If \code{TRUE}, use gray background, else use white
background.}
}
\value{
An object of class \code{\link{theme}}.
}
\description{
Style plots similar to those in \emph{The Economist}.
}
\details{
\code{theme_economist} implements the standard bluish-gray
background theme in the print \emph{The Economist} and
\href{http://economist.com}{economist.com}.
\code{theme_economist_white} implements a variant with a while
panel and light gray (or white) background used by \emph{The Economist}
blog \href{http://www.economist.com/blogs/graphicdetail}{Graphic Detail}.

\emph{The Economist} uses "ITC Officina Sans" as its font for graphs. If
you have access to this font, you can use it with the
\pkg{extrafont} package. "Verdana" is a good substitute.
}
\examples{


library("ggplot2")
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour = factor(gear))) +
     facet_wrap(~am) +
     # Economist puts scales on the right-hand side
     scale_y_continuous(position = "right")

## Standard
p + theme_economist() + scale_colour_economist()

## Stata colors
p + theme_economist(stata = TRUE) + scale_colour_economist(stata = TRUE)

## Darker plot region
p + theme_economist(dkpanel = TRUE) + scale_colour_economist(stata = TRUE)

# Change axis lines to vertical
p + theme_economist(horizontal = FALSE) +
    scale_colour_economist() +
    coord_flip()

## White panel/light gray background
p + theme_economist_white() +
    scale_colour_economist()

## All white variant
p + theme_economist_white(gray_bg = FALSE) +
    scale_colour_economist()
\dontrun{
## The Economist uses ITC Officina Sans
library(extrafont)
p + theme_economist(base_family="ITC Officina Sans") +
    scale_colour_economist()
##D
## Verdana is a widely available substitute
p + theme_economist(base_family="Verdana") +
    scale_colour_economist()
}



}
\references{
\itemize{
\item \href{http://economist.com}{The Economist}
\item \href{http://spiekermann.com/en/itc-officina-display/}{Spiekerblog, "ITC Officina Display", January 1, 2007.}
\item \url{http://www.economist.com/help/about-us}
}
}
\seealso{
\code{\link[latticeExtra]{theEconomist.theme}} for an Economist
theme for lattice plots.
}
