% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pander.R
\name{theme_pander}
\alias{theme_pander}
\title{A ggplot theme originated from the pander package}
\usage{
theme_pander(base_size = 12, base_family = "sans", nomargin = TRUE,
  ff = NULL, fc = "black", fs = NULL, gM = TRUE, gm = TRUE,
  gc = "grey", gl = "dashed", boxes = FALSE, bc = "white",
  pc = "transparent", lp = "right", axis = 1)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{nomargin}{suppress the white space around the plot (boolean)}

\item{ff}{font family, like \code{sans}. Deprecated: use \code{base_family} instead.}

\item{fc}{font color (name or hexa code)}

\item{fs}{font size (integer). Deprecated: use \code{base_size} instead.}

\item{gM}{major grid (boolean)}

\item{gm}{minor grid (boolean)}

\item{gc}{grid color (name or hexa code)}

\item{gl}{grid line type (\code{lty})}

\item{boxes}{to render a border around the plot or not}

\item{bc}{background color (name or hexa code)}

\item{pc}{panel background color (name or hexa code)}

\item{lp}{legend position}

\item{axis}{axis angle as defined in \code{par(les)}}
}
\description{
The \pkg{pander} ships with a default theme when the 'unify plots' option is
enabled via \code{panderOptions}, which is now also available outside of \pkg{pander} internals, like \code{evals}, \code{eval.msgs} or \code{Pandoc.brew}.
}
\examples{
\dontrun{
p <- qplot(mpg, wt, data = mtcars)
p + theme_pander()

panderOptions('graph.grid.color', 'red')
p + theme_pander()

p <- ggplot(mtcars, aes(wt, mpg, colour = factor(cyl))) + geom_point()
p + theme_pander() + scale_color_pander()

## standard examples of the ggtheme package
qplot(carat, price, data = diamonds, colour = cut) +
  theme_pander() +
  scale_colour_pander()
ggplot(diamonds, aes(clarity, fill = cut)) +
  geom_bar() +
  scale_fill_pander() +
  theme_pander()
}
}

