% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-arrowlength.R
\name{theme_arrowlength}
\alias{theme_arrowlength}
\alias{theme_arrowcustomlength}
\alias{theme_arrowlength}
\alias{theme_arrowsmall}
\alias{theme_arrowshort}
\alias{theme_arrownormal}
\alias{theme_arrowdefault}
\alias{theme_arrowlarge}
\alias{theme_arrowlong}
\title{Change the Length of the Ternary Arrows}
\usage{
theme_arrowcustomlength(start = getOption("tern.arrow.start"),
  finish = getOption("tern.arrow.finish"))

theme_arrowlength(start = getOption("tern.arrow.start"),
  finish = getOption("tern.arrow.finish"))

theme_arrowsmall()

theme_arrowshort()

theme_arrownormal()

theme_arrowdefault()

theme_arrowlarge()

theme_arrowlong()
}
\arguments{
\item{start}{a numeric scalar, or numeric vector of length three (3), representing the fractional [0,1] position along 
the axis where the arrow/s should START.}

\item{finish}{a numeric scalar, or numeric vector of length three (3), representing the fractional [0,1] position along 
the axis where the arrow/s should FINISH.}
}
\description{
A set of convenience functions to rapidly change the length of the ternary arrows, the convenience functions include presets 
(short, normal, long), or makes provision for the user to specify custom fractional starting and ending values relative to the
size of the ternary axis. In the event that the user elects to specify the values via the \code{theme_arrowcustomlength} (or its aliasses), 
then the user can specify a single scalar value which apply to all three (3) arrows, or, alternatively, can provide a numeric vector
of length three (3), one for each arrow respectively.
}
\details{
If the ternary arrows are switched OFF 
(via the \code{\link{theme_hidearrows}} command, or the \code{theme(tern.axis.arrow.show=FALSE)} theme element), then under such circumstance,
these convenience functions will turn ON the ternary arrows, essentially running \code{\link{theme_showarrows}} or \code{theme(tern.axis.arrow.show=TRUE)}

If for some reason, the \code{start} and \code{finish} arguments are identical, then the ternary arrows will be switched OFF, tantamount to
running the \code{\link{theme_hidearrows}} convenience function.
}
\section{Custom Length}{

\code{theme_arrowcustomlength} or \code{theme_arrowlength} (alias) sets the ternary arrow lengths to values as specified by the user, 
occupying a length between the values as specified by the  \code{start} and \code{finish} arguments (fractions) relative to the 
length of the ternary axis.
}

\section{Short Arrow Length}{

\code{theme_arrowsmall} or \code{theme_arrowshort}(alias) reduces the ternary arrows to short arrows, occupying a length between 
\strong{0.4} and \strong{0.6} of the length of the ternary axis
}

\section{Normal/Default Arrow Length}{

\code{theme_arrownormal} or \code{theme_arrowdefault}(alias) reduces the ternary arrows to normally sized arrows, occupying a length between 
\code{getOption("tern.arrow.start")} and \code{getOption("tern.arrow.finish")} global option values, whatever they may be.
}

\section{Long Arrow Length}{

\code{theme_arrowlarge} or \code{theme_arrowlong}(alias) increases the ternary arrows to long arrows occupying a length between 
\strong{0.2} and \strong{0.8} of the length of the ternary axis
}

\examples{
 #Create base plot
 plot <- ggtern(data=data.frame(x=1,y=1,z=1),aes(x,y,z)) + geom_point()

 #Pre-Specified Values
 plot + theme_arrowsmall()
 
 ## Alternatives, Uncomment lines below
 plot + theme_arrownormal()
 plot + theme_arrowlarge()
 plot + theme_arrowcustomlength(.1,.8)
 plot + theme_arrowlength(start=c(.1,.25,.4),finish=c(.9,.75,.6))
}
\seealso{
\code{theme_arrowbaseline} and \code{theme(tern.axis.arrow.sep=X)} for methods to adjust the separation distance of the ternary arrows 
from the ternary axes.
}
\author{
Nicholas Hamilton
}
