% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-confidence-tern.R, R/stat-confidence-tern.R, R/geom-mean-ellipse.R
\docType{data}
\name{geom_confidence_tern}
\alias{GeomConfidenceTern}
\alias{GeomMeanEllipse}
\alias{StatConfidenceTern}
\alias{geom_confidence}
\alias{geom_confidence_tern}
\alias{stat_confidence}
\alias{stat_confidence_tern}
\title{Confidence Interval}
\usage{
geom_confidence_tern(mapping = NULL, data = NULL, stat = "ConfidenceTern",
  position = "identity", ..., lineend = "butt", linejoin = "round",
  linemitre = 1, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)

stat_confidence_tern(mapping = NULL, data = NULL, geom = "ConfidenceTern",
  position = "identity", ..., contour = TRUE, n = 100, h = NULL,
  na.rm = FALSE, breaks = c(0.5, 0.9, 0.95), show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{geom}{Use to override the default connection between
\code{geom_smooth} and \code{stat_smooth}.}

\item{contour}{If \code{TRUE}, contour the results of the 2d density estimation}

\item{n}{number of grid points in each direction}

\item{h}{Bandwidth (vector of length two). If \code{NULL}, estimated using \code{\link[MASS]{bandwidth.nrd}}.}

\item{breaks}{the confidence intervals, default to 50, 90 and 95 percent.}
}
\description{
Calculates the confidence intervals, via the Mahalnobis Distance and use of the \code{\link[=ilr]{Log-Ratio}} Transformation

Statistic
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "ConfidenceTern")}
}

\section{Computed variables}{
 
Same as \code{\link{stat_contour}}
}
\examples{
  data(Feldspar)
  ggtern(data=Feldspar,aes(An,Ab,Or)) + 
    geom_point() + 
    geom_confidence_tern()
}
\author{
Nicholas Hamilton
}
\keyword{datasets}

