% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggcorrmat.R
\name{grouped_ggcorrmat}
\alias{grouped_ggcorrmat}
\title{Visualization of a correlalogram (or correlation matrix) for all
levels of a grouping variable}
\usage{
grouped_ggcorrmat(
  data,
  cor.vars = NULL,
  cor.vars.names = NULL,
  grouping.var,
  title.prefix = NULL,
  output = "plot",
  ...,
  plotgrid.args = list(),
  title.text = NULL,
  title.args = list(size = 16, fontface = "bold"),
  caption.text = NULL,
  caption.args = list(size = 10),
  sub.text = NULL,
  sub.args = list(size = 12)
)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{cor.vars}{List of variables for which the correlation matrix is to be
computed and visualized. If \code{NULL} (default), all numeric variables from
\code{data} will be used.}

\item{cor.vars.names}{Optional list of names to be used for \code{cor.vars}. The
names should be entered in the same order.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{output}{Character that decides expected output from this
function: \code{"plot"} (for visualization matrix) or \code{"correlations"} (or
\code{"corr"} or \code{"r"}; for correlation matrix) or \code{"p-values"} (or \code{"p.values"}
or \code{"p"}; for a matrix of \emph{p}-values) or \code{"ci"} (for a tibble with
confidence intervals for unique correlation pairs; not available for robust
correlation) or \code{"n"} (or \code{"sample.size"} for a tibble with sample sizes
for each correlation pair).}

\item{...}{
  Arguments passed on to \code{\link[=ggcorrmat]{ggcorrmat}}
  \describe{
    \item{\code{matrix.type}}{Character, \code{"full"} (default), \code{"upper"} or \code{"lower"},
display full matrix, lower triangular or upper triangular matrix.}
    \item{\code{type}}{A character string indicating which correlation
coefficient is to be computed (\code{"pearson"} (default) or \code{"kendall"} or
\code{"spearman"}). \code{"robust"} can also be entered but only if \code{output} argument
is set to either \code{"correlations"} or \code{"p-values"}. The robust correlation
used is percentage bend correlation (see \code{?WRS2::pball}). Abbreviations
will also work: \code{"p"} (for parametric/Pearson's \emph{r}), \code{"np"}
(nonparametric/Spearman's \emph{rho}), \code{"r"} (robust).}
    \item{\code{beta}}{A numeric bending constant for percentage bend robust correlation
coefficient (Default: \code{0.1}).}
    \item{\code{sig.level}}{Significance level (Default: \code{0.05}). If the \emph{p}-value in
\emph{p}-value matrix is bigger than \code{sig.level}, then the corresponding
correlation coefficient is regarded as insignificant and flagged as such in
the plot. This argument is relevant only when \code{output = "plot"}.}
    \item{\code{p.adjust.method}}{What adjustment for multiple tests should be used?
(\code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"},
\code{"fdr"}, \code{"none"}). See \code{stats::p.adjust} for details about why to use
\code{"holm"} rather than \code{"bonferroni"}). Default is \code{"none"}. If adjusted
\emph{p}-values are displayed in the visualization of correlation matrix, the
\strong{adjusted} \emph{p}-values will be used for the \strong{upper} triangle, while
\strong{unadjusted} \emph{p}-values will be used for the \strong{lower} triangle of the
matrix.}
    \item{\code{colors}}{A vector of 3 colors for low, mid, and high correlation values.
If set to \code{NULL}, manual specification of colors will be turned off and 3
colors from the specified \code{palette} from \code{package} will be selected.}
    \item{\code{subtitle}}{The text for the plot subtitle.}
    \item{\code{caption}}{The text for the plot caption. If \code{NULL}, a default caption
will be shown.}
    \item{\code{caption.default}}{Logical that decides whether the default caption
should be shown (default: \code{TRUE}).}
    \item{\code{pch}}{Decides the glyphs (read point shapes) to be used for
insignificant correlation coefficients (only valid when \code{insig = "pch"}).
Default value is \code{pch = 4}.}
    \item{\code{ggcorrplot.args}}{A list of additional (mostly aesthetic) arguments that
will be passed to \code{ggcorrplot::ggcorrplot} function. The list should avoid
any of the following arguments since they are already being used: \code{corr},
\code{method}, \code{p.mat}, \code{sig.level}, \code{ggtheme}, \code{colors}, \code{matrix.type}, \code{lab},
\code{pch}, \code{legend.title}, \code{digits}.}
    \item{\code{k}}{Decides the number of decimal digits to be displayed
(Default: \code{2}).}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{method}}{Smoothing method (function) to use, accepts either a character vector,
e.g. \code{"auto"}, \code{"lm"}, \code{"glm"}, \code{"gam"}, \code{"loess"} or a function, e.g.
\code{MASS::rlm} or \code{mgcv::gam}, \code{stats::lm}, or \code{stats::loess}.

For \code{method = "auto"} the smoothing method is chosen based on the
size of the largest group (across all panels). \code{\link[stats:loess]{stats::loess()}} is
used for less than 1,000 observations; otherwise \code{\link[mgcv:gam]{mgcv::gam()}} is
used with \code{formula = y ~ s(x, bs = "cs")}. Somewhat anecdotally,
\code{loess} gives a better appearance, but is \eqn{O(N^{2})}{O(N^2)} in memory,
so does not work for larger datasets.

If you have fewer than 1,000 observations but want to use the same \code{gam()}
model that \code{method = "auto"} would use, then set
\code{method = "gam", formula = y ~ s(x, bs = "cs")}.}
    \item{\code{conf.level}}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}
    \item{\code{messages}}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
    \item{\code{package}}{Name of package from which the palette is desired as string
or symbol.}
    \item{\code{palette}}{Name of palette as string or symbol.}
    \item{\code{direction}}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}
  }}

\item{plotgrid.args}{A list of additional arguments to \code{cowplot::plot_grid}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}
}
\value{
Correlation matrix plot or correlation coefficient matrix or matrix
of \emph{p}-values.
}
\description{
Helper function for \code{ggstatsplot::ggcorrmat} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# for plot
# (without specifying needed variables; all numeric variables will be used)
ggstatsplot::grouped_ggcorrmat(
  data = ggplot2::msleep,
  grouping.var = vore
)

# for getting plot
ggstatsplot::grouped_ggcorrmat(
  data = ggplot2::msleep,
  grouping.var = vore,
  cor.vars = sleep_total:bodywt,
  corr.method = "r",
  p.adjust.method = "holm",
  colors = NULL,
  package = "wesanderson",
  palette = "BottleRocket2",
  plotgrid.args = list(nrow = 2)
)

# for getting correlations
ggstatsplot::grouped_ggcorrmat(
  data = ggplot2::msleep,
  grouping.var = vore,
  cor.vars = sleep_total:bodywt,
  output = "correlations"
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggcorrmat.html}
}
\seealso{
\code{\link{ggcorrmat}}, \code{\link{ggscatterstats}},
\code{\link{grouped_ggscatterstats}}
}
