% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_stats.R
\name{extract_stats}
\alias{extract_stats}
\alias{extract_subtitle}
\alias{extract_caption}
\title{Extracting data frames or expressions from \code{{ggstatsplot}} plots}
\usage{
extract_stats(p, ...)

extract_subtitle(p)

extract_caption(p)
}
\arguments{
\item{p}{A plot from \code{{ggstatsplot}} package}

\item{...}{Ignored}
}
\value{
A list of tibbles containing summaries of various statistical analyses.
The exact details included will depend on the function.
}
\description{
Extracting data frames or expressions from \code{{ggstatsplot}} plots
}
\details{
These are convenience functions to extract data frames or expressions with
statistical details that are used to create expressions displayed in
\code{{ggstatsplot}} plots as subtitle, caption, etc. Note that all of this
analysis is carried out by the \code{{statsExpressions}}
\href{https://indrajeetpatil.github.io/statsExpressions/}{package}. And so if you
are using these functions only to extract data frames, you are better off
using that package.

The only exception is the \code{ggcorrmat()} function. But, if a data frame is
what you want, you shouldn't be using \code{ggcorrmat()} anyway. You can use
\code{correlation::correlation()} function which provides tidy data frames by
default.
}
\examples{
\dontshow{if (requireNamespace("PMCMRplus", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
set.seed(123)

# non-grouped function -----------------------------

p <- ggbetweenstats(mtcars, cyl, mpg)
extract_stats(p)

# the exact details depend on the function
ggbarstats(mtcars, cyl, am) \%>\% extract_stats()

# grouped function -----------------------------
p <- grouped_ggbarstats(
  Titanic_full,
  x = Survived,
  y = Sex,
  grouping.var = Age
)

extract_stats(p[[1L]])
extract_stats(p[[2L]])
}
\dontshow{\}) # examplesIf}
}
