% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-star.R
\name{geom_star}
\alias{geom_star}
\title{Star layer}
\usage{
geom_star(
  mapping = NULL,
  data = NULL,
  na.rm = FALSE,
  stat = "identity",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{na.rm}{If `FALSE`, the default, missing values are removed with
a warning. If `TRUE`, missing values are silently removed.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{layer}}.}
}
\value{
polygonal point layer
}
\description{
geom_star provides the multiple geometric shape to create scatter plot or 
other point plot, it is like the 'geom_point' of 'ggplot2'.
Note: the 'left-triangle' (17, 19) and 'right-triangle' (18, 20) are 
developed to plot the 'triangle-heatmap'. Their centers are not in their internal,
but the center of hypotenuse.
}
\details{
\itemize{
    \item \code{starshape} the shape of point, default is 1 (star shape).
    \item \code{starstroke} control the thickness of margin of point, default is 0.5.
    \item \code{size} the size of point, default is 1.5.
    \item \code{colour} the colour of margin, default is 'black'.
    \item \code{fill} the colour of fill, default is NA.
    \item \code{alpha} the transparency of fill, default is 1.
    \item \code{angle} control the angle of rotation of point, default is 0.
 }
}
\section{Aesthetics}{

\code{geom_star()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \code{alpha}
  \item \code{angle}
  \item \code{colour}
  \item \code{fill}
  \item \code{group}
  \item \code{phase}
  \item \code{size}
  \item \code{starshape}
  \item \code{starstroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{
library(ggplot2)
p <- ggplot(iris, aes(x=Sepal.Length, 
                      y=Sepal.Width, 
                      starshape=Species)) + 
     geom_star(size=4)
p
}
\author{
Shuangbin Xu
}
