% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-response-spct.R
\name{scale_y_s.e.response_continuous}
\alias{scale_y_s.e.response_continuous}
\alias{scale_y_s.q.response_continuous}
\alias{scale_y_s.e.action_continuous}
\alias{scale_y_s.q.action_continuous}
\title{Spectral response and action y-scales}
\usage{
scale_y_s.e.response_continuous(
  unit.exponent = 0,
  name = s.e.response_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = ifelse(is.numeric(normalized),
    round(normalized, 1), unique(normalized)), axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = -unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.response"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_s.q.response_continuous(
  unit.exponent = 0,
  name = s.q.response_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = ifelse(is.numeric(normalized),
    round(normalized, 1), unique(normalized)), axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = -unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.response"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_s.e.action_continuous(
  unit.exponent = 0,
  name = s.e.action_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = ifelse(is.numeric(normalized),
    round(normalized, 1), unique(normalized)), axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = -unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.action"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)

scale_y_s.q.action_continuous(
  unit.exponent = 0,
  name = s.q.action_label(unit.exponent = unit.exponent, format = format, label.text =
    label.text, scaled = scaled, normalized = ifelse(is.numeric(normalized),
    round(normalized, 1), unique(normalized)), axis.symbols = axis.symbols),
  labels = SI_pl_format(exponent = -unit.exponent),
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.action"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{labels}{The tick labels or a function to generate them.}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale y continuous with defaults suitable for response and action spectra.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}.
}
\examples{

ggplot(ccd.spct) +
  geom_line() +
  scale_y_s.e.action_continuous() + #  per joule
  scale_x_wl_continuous()

ggplot(ccd.spct) +
  geom_line() +
  scale_y_s.e.response_continuous() + #  per joule
  scale_x_wl_continuous()

ggplot(ccd.spct) +
  geom_line() +
  scale_y_s.e.response_continuous(unit.exponent = 6) + # per mega joule
  scale_x_wl_continuous()

ggplot(ccd.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.response_continuous() + # per mol
  scale_x_wl_continuous()

ggplot(ccd.spct, unit.out = "photon") +
  geom_line() +
  scale_y_s.q.response_continuous(unit.exponent = 3) + # per 1000 moles
  scale_x_wl_continuous()

norm_ccd.spct <- normalize(ccd.spct, norm = "max")
ggplot(norm_ccd.spct) +
  geom_line() +
  scale_y_s.e.response_continuous(normalized = getNormalized(norm_ccd.spct)) +
  scale_x_wl_continuous()

if (packageVersion("photobiology") > "0.11.4") {
  ggplot(norm_ccd.spct) +
    geom_line() +
    scale_y_s.e.response_continuous(normalized =
      normalization(norm_ccd.spct)$norm.type) +
    scale_x_wl_continuous()
}
photon_as_default()

norm_ccd.spct <- normalize(ccd.spct, norm = "max")
ggplot(norm_ccd.spct) +
  geom_line() +
  scale_y_s.q.response_continuous(normalized = getNormalized(norm_ccd.spct)) +
  scale_x_wl_continuous()

ggplot(norm_ccd.spct) +
  geom_line() +
  scale_y_s.q.response_continuous(unit.exponent = 2,
                                  normalized = getNormalized(norm_ccd.spct)) +
  scale_x_wl_continuous()

unset_radiation_unit_default()

}
