% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-filter-spct.R
\name{plot.filter_spct}
\alias{plot.filter_spct}
\title{Plot method for filter spectra.}
\usage{
\method{plot}{filter_spct}(x, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(),
  UVA(), PAR())), range = NULL,
  plot.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  pc.out = FALSE, label.qty = NULL, span = NULL, annotations = NULL,
  time.format = "", tz = "UTC", text.size = 2.5, na.rm = TRUE)
}
\arguments{
\item{x}{a filter_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{plot.qty}{character string one of "transmittance" or "absorbance"}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector}

\item{time.format}{character Format as accepted by \code{\link[base]{strptime}}.}

\item{tz}{character Time zone to use for title and/or subtitle.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{na.rm}{logical.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a filter_spct
object.
}
\note{
The ggplot object returned can be further manipulated and added to.
  Except when no annotations are added, limits are set for the x-axis and
  y-axis scales. The y scale limits are expanded to include all data, or at
  least to the range of expected values. The plotting of absorbance is an
  exception as the y-axis is not extended past 6 a.u. In the case of
  absorbance, values larger than 6 a.u. are rarely meaningful due to stray
  light during measurement. However, when transmittance values below the
  detection limit are rounded to zero, and later converted into absorbance,
  values Inf a.u. result, disrupting the plot. Scales are further expanded so
  as to make space for the annotations.
}
\examples{
library(photobiology)
plot(yellow_gel.spct)
plot(yellow_gel.spct, pc.out = TRUE)

}
\seealso{
Other plot functions: \code{\link{plot.calibration_spct}},
  \code{\link{plot.cps_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}
