% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03.lancet.R
\name{pal_lancet}
\alias{pal_lancet}
\title{Lancet Journal Color Palettes}
\usage{
pal_lancet(palette = c("lanonc"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"lanonc"}
(9-color palette inspired by \emph{Lancet Oncology}).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}
}
\description{
Color palettes inspired by Lancet journals,
such as \emph{Lancet Oncology}.
}
\examples{
library("scales")
show_col(pal_lancet("lanonc")(9))
show_col(pal_lancet("lanonc", alpha = 0.6)(9))
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{http://nanx.me}{http://nanx.me}>
}

